package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ClientSslContext;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ClientSslContextConsumer<T extends ClientSslContext<T>> {

	/**
	 * Configure a pre-constructed instance of ClientSslContext resource
	 * 
	 * @parameter Instance of ClientSslContext to configure
	 * @return nothing
	 */
	void accept(T value);

	default ClientSslContextConsumer<T> andThen(
			ClientSslContextConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}