package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CustomCredentialSecurityFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomCredentialSecurityFactoryConsumer<T extends CustomCredentialSecurityFactory<T>> {

	/**
	 * Configure a pre-constructed instance of CustomCredentialSecurityFactory
	 * resource
	 * 
	 * @parameter Instance of CustomCredentialSecurityFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomCredentialSecurityFactoryConsumer<T> andThen(
			CustomCredentialSecurityFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}