package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CustomRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomRealmConsumer<T extends CustomRealm<T>> {

	/**
	 * Configure a pre-constructed instance of CustomRealm resource
	 * 
	 * @parameter Instance of CustomRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomRealmConsumer<T> andThen(CustomRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}