package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CustomRoleMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomRoleMapperConsumer<T extends CustomRoleMapper<T>> {

	/**
	 * Configure a pre-constructed instance of CustomRoleMapper resource
	 * 
	 * @parameter Instance of CustomRoleMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomRoleMapperConsumer<T> andThen(
			CustomRoleMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}