package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.elytron.Format;

/**
 * An audit logger that logs to a local file.
 */
@Address("/subsystem=elytron/file-audit-log=*")
@ResourceType("file-audit-log")
public class FileAuditLog<T extends FileAuditLog<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The format to use to record the audit event.")
	private Format format;
	@AttributeDocumentation("Whether every event should be immediately synchronised to disk.")
	private Boolean attributeSynchronized;
	@AttributeDocumentation("Path of the file to be written.")
	private String path;
	@AttributeDocumentation("The relative path to the audit log.")
	private String relativeTo;

	public FileAuditLog(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The format to use to record the audit event.
	 */
	@ModelNodeBinding(detypedName = "format")
	public Format format() {
		return this.format;
	}

	/**
	 * The format to use to record the audit event.
	 */
	@SuppressWarnings("unchecked")
	public T format(Format value) {
		Object oldValue = this.format;
		this.format = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("format", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether every event should be immediately synchronised to disk.
	 */
	@ModelNodeBinding(detypedName = "synchronized")
	public Boolean attributeSynchronized() {
		return this.attributeSynchronized;
	}

	/**
	 * Whether every event should be immediately synchronised to disk.
	 */
	@SuppressWarnings("unchecked")
	public T attributeSynchronized(java.lang.Boolean value) {
		Object oldValue = this.attributeSynchronized;
		this.attributeSynchronized = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeSynchronized", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Path of the file to be written.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Path of the file to be written.
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * The relative path to the audit log.
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The relative path to the audit log.
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(java.lang.String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}
}