package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.FilteringKeyStore;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface FilteringKeyStoreConsumer<T extends FilteringKeyStore<T>> {

	/**
	 * Configure a pre-constructed instance of FilteringKeyStore resource
	 * 
	 * @parameter Instance of FilteringKeyStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default FilteringKeyStoreConsumer<T> andThen(
			FilteringKeyStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}