package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.KeyManager;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface KeyManagerConsumer<T extends KeyManager<T>> {

	/**
	 * Configure a pre-constructed instance of KeyManager resource
	 * 
	 * @parameter Instance of KeyManager to configure
	 * @return nothing
	 */
	void accept(T value);

	default KeyManagerConsumer<T> andThen(KeyManagerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}