package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * A RoleMapper definition for a RoleMapper that performs a logical operation
 * using two referenced RoleMappers.
 */
@Address("/subsystem=elytron/logical-role-mapper=*")
@ResourceType("logical-role-mapper")
public class LogicalRoleMapper<T extends LogicalRoleMapper<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Reference to a role mapper to be used on the left side of the operation.")
	private String left;
	@AttributeDocumentation("The logical operation to be performed on the role mapper mappings.")
	private LogicalOperation logicalOperation;
	@AttributeDocumentation("Reference to a role mapper to be used on the right side of the operation.")
	private String right;

	public LogicalRoleMapper(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum LogicalOperation {
		AND("and"), MINUS("minus"), OR("or"), XOR("xor");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		LogicalOperation(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * Reference to a role mapper to be used on the left side of the operation.
	 */
	@ModelNodeBinding(detypedName = "left")
	public String left() {
		return this.left;
	}

	/**
	 * Reference to a role mapper to be used on the left side of the operation.
	 */
	@SuppressWarnings("unchecked")
	public T left(java.lang.String value) {
		Object oldValue = this.left;
		this.left = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("left", oldValue, value);
		return (T) this;
	}

	/**
	 * The logical operation to be performed on the role mapper mappings.
	 */
	@ModelNodeBinding(detypedName = "logical-operation")
	public LogicalOperation logicalOperation() {
		return this.logicalOperation;
	}

	/**
	 * The logical operation to be performed on the role mapper mappings.
	 */
	@SuppressWarnings("unchecked")
	public T logicalOperation(LogicalOperation value) {
		Object oldValue = this.logicalOperation;
		this.logicalOperation = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("logicalOperation", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to a role mapper to be used on the right side of the operation.
	 */
	@ModelNodeBinding(detypedName = "right")
	public String right() {
		return this.right;
	}

	/**
	 * Reference to a role mapper to be used on the right side of the operation.
	 */
	@SuppressWarnings("unchecked")
	public T right(java.lang.String value) {
		Object oldValue = this.right;
		this.right = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("right", oldValue, value);
		return (T) this;
	}
}