package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A regular expression based principal transformer
 */
@Address("/subsystem=elytron/regex-principal-transformer=*")
@ResourceType("regex-principal-transformer")
public class RegexPrincipalTransformer<T extends RegexPrincipalTransformer<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The regular expression to use to locate the portion of the name to be replaced.")
	private String pattern;
	@AttributeDocumentation("Should all occurrences of the pattern matched be replaced or only the first occurrence.")
	private Boolean replaceAll;
	@AttributeDocumentation("The value to be used as the replacement.")
	private String replacement;

	public RegexPrincipalTransformer(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The regular expression to use to locate the portion of the name to be
	 * replaced.
	 */
	@ModelNodeBinding(detypedName = "pattern")
	public String pattern() {
		return this.pattern;
	}

	/**
	 * The regular expression to use to locate the portion of the name to be
	 * replaced.
	 */
	@SuppressWarnings("unchecked")
	public T pattern(java.lang.String value) {
		Object oldValue = this.pattern;
		this.pattern = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("pattern", oldValue, value);
		return (T) this;
	}

	/**
	 * Should all occurrences of the pattern matched be replaced or only the
	 * first occurrence.
	 */
	@ModelNodeBinding(detypedName = "replace-all")
	public Boolean replaceAll() {
		return this.replaceAll;
	}

	/**
	 * Should all occurrences of the pattern matched be replaced or only the
	 * first occurrence.
	 */
	@SuppressWarnings("unchecked")
	public T replaceAll(java.lang.Boolean value) {
		Object oldValue = this.replaceAll;
		this.replaceAll = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("replaceAll", oldValue, value);
		return (T) this;
	}

	/**
	 * The value to be used as the replacement.
	 */
	@ModelNodeBinding(detypedName = "replacement")
	public String replacement() {
		return this.replacement;
	}

	/**
	 * The value to be used as the replacement.
	 */
	@SuppressWarnings("unchecked")
	public T replacement(java.lang.String value) {
		Object oldValue = this.replacement;
		this.replacement = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("replacement", oldValue, value);
		return (T) this;
	}
}