package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ServiceLoaderHTTPServerMechanismFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ServiceLoaderHTTPServerMechanismFactoryConsumer<T extends ServiceLoaderHTTPServerMechanismFactory<T>> {

	/**
	 * Configure a pre-constructed instance of
	 * ServiceLoaderHTTPServerMechanismFactory resource
	 * 
	 * @parameter Instance of ServiceLoaderHTTPServerMechanismFactory to
	 *            configure
	 * @return nothing
	 */
	void accept(T value);

	default ServiceLoaderHTTPServerMechanismFactoryConsumer<T> andThen(
			ServiceLoaderHTTPServerMechanismFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}