package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Definition of a simple RealmMapper that attempts to extract the realm name
 * using the capture group from the regular expression, if that does not provide
 * a match then the delegate RealmMapper is used instead.
 */
@Address("/subsystem=elytron/simple-regex-realm-mapper=*")
@ResourceType("simple-regex-realm-mapper")
public class SimpleRegexRealmMapper<T extends SimpleRegexRealmMapper<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The RealmMapper to delegate to if there is no match using the pattern.")
	private String delegateRealmMapper;
	@AttributeDocumentation("The regular expression which must contain at least one capture group to extract the realm from the name. If the regular expression matches more than one capture group, the first capture group is used.")
	private String pattern;

	public SimpleRegexRealmMapper(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The RealmMapper to delegate to if there is no match using the pattern.
	 */
	@ModelNodeBinding(detypedName = "delegate-realm-mapper")
	public String delegateRealmMapper() {
		return this.delegateRealmMapper;
	}

	/**
	 * The RealmMapper to delegate to if there is no match using the pattern.
	 */
	@SuppressWarnings("unchecked")
	public T delegateRealmMapper(java.lang.String value) {
		Object oldValue = this.delegateRealmMapper;
		this.delegateRealmMapper = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("delegateRealmMapper", oldValue, value);
		return (T) this;
	}

	/**
	 * The regular expression which must contain at least one capture group to
	 * extract the realm from the name. If the regular expression matches more
	 * than one capture group, the first capture group is used.
	 */
	@ModelNodeBinding(detypedName = "pattern")
	public String pattern() {
		return this.pattern;
	}

	/**
	 * The regular expression which must contain at least one capture group to
	 * extract the realm from the name. If the regular expression matches more
	 * than one capture group, the first capture group is used.
	 */
	@SuppressWarnings("unchecked")
	public T pattern(java.lang.String value) {
		Object oldValue = this.pattern;
		this.pattern = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("pattern", oldValue, value);
		return (T) this;
	}
}