package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.StateTransferThreadPool;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface StateTransferThreadPoolConsumer<T extends StateTransferThreadPool<T>> {

	/**
	 * Configure a pre-constructed instance of StateTransferThreadPool resource
	 * 
	 * @parameter Instance of StateTransferThreadPool to configure
	 * @return nothing
	 */
	void accept(T value);

	default StateTransferThreadPoolConsumer<T> andThen(
			StateTransferThreadPoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}