package org.wildfly.swarm.config.jgroups.stack.relay;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.jgroups.stack.relay.RemoteSiteConsumer;
import org.wildfly.swarm.config.jgroups.stack.relay.RemoteSiteSupplier;
import org.wildfly.swarm.config.jgroups.stack.relay.RemoteSite;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * The configuration of a RELAY protocol
 */
@Address("/subsystem=jgroups/stack=*/relay=relay.RELAY2")
@ResourceType("relay")
@Implicit
public class RELAY2<T extends RELAY2<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private RELAY2Resources subresources = new RELAY2Resources();
	@AttributeDocumentation("The module with which to resolve the protocol type.")
	private String module;
	@AttributeDocumentation("The properties of this protocol.")
	private Map properties;
	@AttributeDocumentation("The name of the local site.")
	private String site;
	@AttributeDocumentation("Indicates whether or not this protocol will collect statistics overriding stack configuration.")
	private Boolean statisticsEnabled;

	public RELAY2() {
		super();
		this.key = "relay.RELAY2";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public RELAY2Resources subresources() {
		return this.subresources;
	}

	/**
	 * Add all RemoteSite objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RemoteSite objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteSites(java.util.List<RemoteSite> value) {
		this.subresources.remoteSites = value;
		return (T) this;
	}

	/**
	 * Add the RemoteSite object to the list of subresources
	 * 
	 * @param value
	 *            The RemoteSite to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteSite(RemoteSite value) {
		this.subresources.remoteSites.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteSite object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteSite resource
	 * @param config
	 *            The RemoteSiteConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteSite(java.lang.String childKey, RemoteSiteConsumer consumer) {
		RemoteSite<? extends RemoteSite> child = new RemoteSite<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		remoteSite(child);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteSite object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteSite resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteSite(java.lang.String childKey) {
		remoteSite(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RemoteSite object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T remoteSite(RemoteSiteSupplier supplier) {
		remoteSite(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for RELAY2
	 */
	public static class RELAY2Resources {
		/**
		 * A remote site to which to bridge.
		 */
		@ResourceDocumentation("A remote site to which to bridge.")
		@SubresourceInfo("remoteSite")
		private List<RemoteSite> remoteSites = new java.util.ArrayList<>();

		/**
		 * Get the list of RemoteSite resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteSite> remoteSites() {
			return this.remoteSites;
		}

		public RemoteSite remoteSite(java.lang.String key) {
			return this.remoteSites.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * The module with which to resolve the protocol type.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module with which to resolve the protocol type.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * The properties of this protocol.
	 */
	@ModelNodeBinding(detypedName = "properties")
	public Map properties() {
		return this.properties;
	}

	/**
	 * The properties of this protocol.
	 */
	@SuppressWarnings("unchecked")
	public T properties(java.util.Map value) {
		Object oldValue = this.properties;
		this.properties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("properties", oldValue, value);
		return (T) this;
	}

	/**
	 * The properties of this protocol.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String key, java.lang.Object value) {
		if (this.properties == null) {
			this.properties = new java.util.HashMap<>();
		}
		this.properties.put(key, value);
		return (T) this;
	}

	/**
	 * The name of the local site.
	 */
	@ModelNodeBinding(detypedName = "site")
	public String site() {
		return this.site;
	}

	/**
	 * The name of the local site.
	 */
	@SuppressWarnings("unchecked")
	public T site(java.lang.String value) {
		Object oldValue = this.site;
		this.site = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("site", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether or not this protocol will collect statistics overriding
	 * stack configuration.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Indicates whether or not this protocol will collect statistics overriding
	 * stack configuration.
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(java.lang.Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}
}