package org.wildfly.swarm.config.jmx;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration for exposing the 'resolved' model controller in the
 * MBeanServer. This facade will expose all simple attributes and operation
 * parameters as their type in the underlying model. Reads return the resolved
 * expression if used, or the raw value. You may not use expressions when
 * writing attributes and setting operation parameters.
 */
@Address("/subsystem=jmx/expose-model=resolved")
@ResourceType("expose-model")
@Implicit
public class ResolvedExposeModel<T extends ResolvedExposeModel<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The domain name to use for the 'resolved' model controller JMX facade in the MBeanServer.")
	private String domainName;
	@AttributeDocumentation("If false, PROPERTY type attributes are represented as a DMR string, this is the legacy behaviour. If true, PROPERTY type attributes are represented by a composite type where the key is a string, and the value has the same type as the property in the underlying model.")
	private Boolean properPropertyFormat;

	public ResolvedExposeModel() {
		super();
		this.key = "resolved";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The domain name to use for the 'resolved' model controller JMX facade in
	 * the MBeanServer.
	 */
	@ModelNodeBinding(detypedName = "domain-name")
	public String domainName() {
		return this.domainName;
	}

	/**
	 * The domain name to use for the 'resolved' model controller JMX facade in
	 * the MBeanServer.
	 */
	@SuppressWarnings("unchecked")
	public T domainName(java.lang.String value) {
		Object oldValue = this.domainName;
		this.domainName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("domainName", oldValue, value);
		return (T) this;
	}

	/**
	 * If false, PROPERTY type attributes are represented as a DMR string, this
	 * is the legacy behaviour. If true, PROPERTY type attributes are
	 * represented by a composite type where the key is a string, and the value
	 * has the same type as the property in the underlying model.
	 */
	@ModelNodeBinding(detypedName = "proper-property-format")
	public Boolean properPropertyFormat() {
		return this.properPropertyFormat;
	}

	/**
	 * If false, PROPERTY type attributes are represented as a DMR string, this
	 * is the legacy behaviour. If true, PROPERTY type attributes are
	 * represented by a composite type where the key is a string, and the value
	 * has the same type as the property in the underlying model.
	 */
	@SuppressWarnings("unchecked")
	public T properPropertyFormat(java.lang.Boolean value) {
		Object oldValue = this.properPropertyFormat;
		this.properPropertyFormat = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("properPropertyFormat", oldValue, value);
		return (T) this;
	}
}