package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Log files that are available to be read.
 */
@Addresses({"/subsystem=logging/logging-profile=*/log-file=*",
		"/subsystem=logging/log-file=*"})
@ResourceType("log-file")
public class LogFile<T extends LogFile<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The size of the log file in bytes.")
	private Long fileSize;
	@AttributeDocumentation("The date, in milliseconds, the file was last modified.")
	private Long lastModifiedTime;
	@AttributeDocumentation("The date, in ISO 8601 format, the file was last modified.")
	private String lastModifiedTimestamp;
	@AttributeDocumentation("Provides the server log as a response attachment. The response result value is the unique id of the attachment.")
	private String stream;

	public LogFile(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The size of the log file in bytes.
	 */
	@ModelNodeBinding(detypedName = "file-size")
	public Long fileSize() {
		return this.fileSize;
	}

	/**
	 * The size of the log file in bytes.
	 */
	@SuppressWarnings("unchecked")
	public T fileSize(java.lang.Long value) {
		Object oldValue = this.fileSize;
		this.fileSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("fileSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The date, in milliseconds, the file was last modified.
	 */
	@ModelNodeBinding(detypedName = "last-modified-time")
	public Long lastModifiedTime() {
		return this.lastModifiedTime;
	}

	/**
	 * The date, in milliseconds, the file was last modified.
	 */
	@SuppressWarnings("unchecked")
	public T lastModifiedTime(java.lang.Long value) {
		Object oldValue = this.lastModifiedTime;
		this.lastModifiedTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("lastModifiedTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The date, in ISO 8601 format, the file was last modified.
	 */
	@ModelNodeBinding(detypedName = "last-modified-timestamp")
	public String lastModifiedTimestamp() {
		return this.lastModifiedTimestamp;
	}

	/**
	 * The date, in ISO 8601 format, the file was last modified.
	 */
	@SuppressWarnings("unchecked")
	public T lastModifiedTimestamp(java.lang.String value) {
		Object oldValue = this.lastModifiedTimestamp;
		this.lastModifiedTimestamp = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("lastModifiedTimestamp", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Provides the server log as a response attachment. The response result
	 * value is the unique id of the attachment.
	 */
	@ModelNodeBinding(detypedName = "stream")
	public String stream() {
		return this.stream;
	}

	/**
	 * Provides the server log as a response attachment. The response result
	 * value is the unique id of the attachment.
	 */
	@SuppressWarnings("unchecked")
	public T stream(java.lang.String value) {
		Object oldValue = this.stream;
		this.stream = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stream", oldValue, value);
		return (T) this;
	}
}