package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A messaging resource that allows you to configure High Availability for the
 * ActiveMQ server (the value of ha-policy can be live-only, replication-master,
 * replication-slave, or replication-colocated).
 */
@Address("/subsystem=messaging-activemq/server=*/ha-policy=replication-master")
@ResourceType("ha-policy")
@Implicit
public class ReplicationMasterHAPolicy<T extends ReplicationMasterHAPolicy<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Whether to check the cluster for another server using the same server ID when starting up.")
	private Boolean checkForLiveServer;
	@AttributeDocumentation("Name of the cluster used for replication. If it is undefined, the name of the first cluster connection defined in the configuration will be used.")
	private String clusterName;
	@AttributeDocumentation("If set, backup servers will only pair with live servers with matching group-name.")
	private String groupName;
	@AttributeDocumentation("How long to wait until the initiation replication is synchronized.")
	private Long initialReplicationSyncTimeout;

	public ReplicationMasterHAPolicy() {
		super();
		this.key = "replication-master";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Whether to check the cluster for another server using the same server ID
	 * when starting up.
	 */
	@ModelNodeBinding(detypedName = "check-for-live-server")
	public Boolean checkForLiveServer() {
		return this.checkForLiveServer;
	}

	/**
	 * Whether to check the cluster for another server using the same server ID
	 * when starting up.
	 */
	@SuppressWarnings("unchecked")
	public T checkForLiveServer(java.lang.Boolean value) {
		Object oldValue = this.checkForLiveServer;
		this.checkForLiveServer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("checkForLiveServer", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the cluster used for replication. If it is undefined, the name of
	 * the first cluster connection defined in the configuration will be used.
	 */
	@ModelNodeBinding(detypedName = "cluster-name")
	public String clusterName() {
		return this.clusterName;
	}

	/**
	 * Name of the cluster used for replication. If it is undefined, the name of
	 * the first cluster connection defined in the configuration will be used.
	 */
	@SuppressWarnings("unchecked")
	public T clusterName(java.lang.String value) {
		Object oldValue = this.clusterName;
		this.clusterName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clusterName", oldValue, value);
		return (T) this;
	}

	/**
	 * If set, backup servers will only pair with live servers with matching
	 * group-name.
	 */
	@ModelNodeBinding(detypedName = "group-name")
	public String groupName() {
		return this.groupName;
	}

	/**
	 * If set, backup servers will only pair with live servers with matching
	 * group-name.
	 */
	@SuppressWarnings("unchecked")
	public T groupName(java.lang.String value) {
		Object oldValue = this.groupName;
		this.groupName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupName", oldValue, value);
		return (T) this;
	}

	/**
	 * How long to wait until the initiation replication is synchronized.
	 */
	@ModelNodeBinding(detypedName = "initial-replication-sync-timeout")
	public Long initialReplicationSyncTimeout() {
		return this.initialReplicationSyncTimeout;
	}

	/**
	 * How long to wait until the initiation replication is synchronized.
	 */
	@SuppressWarnings("unchecked")
	public T initialReplicationSyncTimeout(java.lang.Long value) {
		Object oldValue = this.initialReplicationSyncTimeout;
		this.initialReplicationSyncTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("initialReplicationSyncTimeout",
					oldValue, value);
		return (T) this;
	}
}