package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.security.ElytronKeyManager;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ElytronKeyManagerConsumer<T extends ElytronKeyManager<T>> {

	/**
	 * Configure a pre-constructed instance of ElytronKeyManager resource
	 * 
	 * @parameter Instance of ElytronKeyManager to configure
	 * @return nothing
	 */
	void accept(T value);

	default ElytronKeyManagerConsumer<T> andThen(
			ElytronKeyManagerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}