package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleSupplier;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModule;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Traditional authentication configuration. Configures a list of login modules
 * to be used.
 */
@Address("/subsystem=security/security-domain=*/authentication=classic")
@ResourceType("authentication")
@Implicit
public class ClassicAuthentication<T extends ClassicAuthentication<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ClassicAuthenticationResources subresources = new ClassicAuthenticationResources();

	public ClassicAuthentication() {
		super();
		this.key = "classic";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ClassicAuthenticationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all LoginModule objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LoginModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T loginModules(java.util.List<LoginModule> value) {
		this.subresources.loginModules = value;
		return (T) this;
	}

	/**
	 * Add the LoginModule object to the list of subresources
	 * 
	 * @param value
	 *            The LoginModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loginModule(LoginModule value) {
		this.subresources.loginModules.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LoginModule object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LoginModule resource
	 * @param config
	 *            The LoginModuleConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loginModule(java.lang.String childKey, LoginModuleConsumer consumer) {
		LoginModule<? extends LoginModule> child = new LoginModule<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		loginModule(child);
		return (T) this;
	}

	/**
	 * Create and configure a LoginModule object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LoginModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loginModule(java.lang.String childKey) {
		loginModule(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LoginModule object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T loginModule(LoginModuleSupplier supplier) {
		loginModule(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for ClassicAuthentication
	 */
	public static class ClassicAuthenticationResources {
		/**
		 * List of authentication modules
		 */
		@ResourceDocumentation("List of authentication modules")
		@SubresourceInfo("loginModule")
		private List<LoginModule> loginModules = new java.util.ArrayList<>();

		/**
		 * Get the list of LoginModule resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LoginModule> loginModules() {
			return this.loginModules;
		}

		public LoginModule loginModule(java.lang.String key) {
			return this.loginModules.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}
}