/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.elytron.SslSession;
import org.wildfly.swarm.config.elytron.SslSessionConsumer;
import org.wildfly.swarm.config.elytron.SslSessionSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=elytron/client-ssl-context=*")
@ResourceType(value="client-ssl-context")
public class ClientSslContext<T extends ClientSslContext<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ClientSslContextResources subresources = new ClientSslContextResources();
    @AttributeDocumentation(value="The count of current active sessions.")
    private Integer activeSessionCount;
    @AttributeDocumentation(value="The filter to apply to specify the enabled cipher suites.")
    private String cipherSuiteFilter;
    @AttributeDocumentation(value="Reference to the key manager to use within the SSLContext.")
    private String keyManager;
    @AttributeDocumentation(value="The enabled protocols.")
    private List<String> protocols;
    @AttributeDocumentation(value="The name of the provider to use. If not specified, all providers from providers will be passed to the SSLContext.")
    private String providerName;
    @AttributeDocumentation(value="The name of the providers to obtain the Provider[] to use to load the SSLContext.")
    private String providers;
    @AttributeDocumentation(value="Reference to the trust manager to use within the SSLContext.")
    private String trustManager;

    public ClientSslContext(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ClientSslContextResources subresources() {
        return this.subresources;
    }

    public T sslSessions(List<SslSession> value) {
        this.subresources.sslSessions = value;
        return (T)this;
    }

    public T sslSession(SslSession value) {
        this.subresources.sslSessions.add(value);
        return (T)this;
    }

    public T sslSession(String childKey, SslSessionConsumer consumer) {
        SslSession child = new SslSession(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.sslSession(child);
        return (T)this;
    }

    public T sslSession(String childKey) {
        this.sslSession(childKey, null);
        return (T)this;
    }

    public T sslSession(SslSessionSupplier supplier) {
        this.sslSession(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="active-session-count")
    public Integer activeSessionCount() {
        return this.activeSessionCount;
    }

    public T activeSessionCount(Integer value) {
        Integer oldValue = this.activeSessionCount;
        this.activeSessionCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("activeSessionCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cipher-suite-filter")
    public String cipherSuiteFilter() {
        return this.cipherSuiteFilter;
    }

    public T cipherSuiteFilter(String value) {
        String oldValue = this.cipherSuiteFilter;
        this.cipherSuiteFilter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cipherSuiteFilter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="key-manager")
    public String keyManager() {
        return this.keyManager;
    }

    public T keyManager(String value) {
        String oldValue = this.keyManager;
        this.keyManager = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keyManager", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocols")
    public List<String> protocols() {
        return this.protocols;
    }

    public T protocols(List<String> value) {
        List<String> oldValue = this.protocols;
        this.protocols = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocols", oldValue, value);
        }
        return (T)this;
    }

    public T protocol(String value) {
        if (this.protocols == null) {
            this.protocols = new ArrayList<String>();
        }
        this.protocols.add(value);
        return (T)this;
    }

    public T protocols(String ... args) {
        this.protocols(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="provider-name")
    public String providerName() {
        return this.providerName;
    }

    public T providerName(String value) {
        String oldValue = this.providerName;
        this.providerName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providerName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="providers")
    public String providers() {
        return this.providers;
    }

    public T providers(String value) {
        String oldValue = this.providers;
        this.providers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providers", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="trust-manager")
    public String trustManager() {
        return this.trustManager;
    }

    public T trustManager(String value) {
        String oldValue = this.trustManager;
        this.trustManager = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("trustManager", oldValue, value);
        }
        return (T)this;
    }

    public static class ClientSslContextResources {
        @ResourceDocumentation(value="A currently established SSL session.")
        @SubresourceInfo(value="sslSession")
        private List<SslSession> sslSessions = new ArrayList<SslSession>();

        @Subresource
        public List<SslSession> sslSessions() {
            return this.sslSessions;
        }

        public SslSession sslSession(String key) {
            return this.sslSessions.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

