/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.elytron.State;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/filtering-key-store=*")
@ResourceType(value="filtering-key-store")
public class FilteringKeyStore<T extends FilteringKeyStore<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="A filter to apply to the aliases returned from the KeyStore, can either be a comma separated list of aliases to return or one of the following formats ALL:-alias1:-alias2, NONE:+alias1:+alias2")
    private String aliasFilter;
    @AttributeDocumentation(value="Name of filtered KeyStore.")
    private String keyStore;
    @AttributeDocumentation(value="The state of the underlying service that represents this KeyStore at runtime, if it is anything other than UP runtime operations will not be available.")
    private State state;

    public FilteringKeyStore(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="alias-filter")
    public String aliasFilter() {
        return this.aliasFilter;
    }

    public T aliasFilter(String value) {
        String oldValue = this.aliasFilter;
        this.aliasFilter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("aliasFilter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="key-store")
    public String keyStore() {
        return this.keyStore;
    }

    public T keyStore(String value) {
        String oldValue = this.keyStore;
        this.keyStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keyStore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="state")
    public State state() {
        return this.state;
    }

    public T state(State value) {
        State oldValue = this.state;
        this.state = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("state", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }
}

