/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/kerberos-security-factory=*")
@ResourceType(value="kerberos-security-factory")
public class KerberosSecurityFactory<T extends KerberosSecurityFactory<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Should the JAAS step of obtaining the credential have debug logging enabled.")
    private Boolean debug;
    @AttributeDocumentation(value="The mechanism names the credential should be usable with. Names will be converted to OIDs and used together with OIDs from mechanism-oids attribute.")
    private List<String> mechanismNames;
    @AttributeDocumentation(value="The mechanism OIDs the credential should be usable with. Will be used together with OIDs derived from names from mechanism-names attribute.")
    private List<String> mechanismOids;
    @AttributeDocumentation(value="How much lifetime (in seconds) should a cached credential have remaining before it is recreated.")
    private Integer minimumRemainingLifetime;
    @AttributeDocumentation(value="Should the KerberosTicket also be obtained and associated with the credential. This is required to be true where credentials are delegated to the server.")
    private Boolean obtainKerberosTicket;
    @AttributeDocumentation(value="The Krb5LoginModule additional options.")
    private Map options;
    @AttributeDocumentation(value="The principal represented by the KeyTab")
    private String principal;
    @AttributeDocumentation(value="How much lifetime (in seconds) should be requested for newly created credentials.")
    private Integer requestLifetime;
    @AttributeDocumentation(value="Is the keytab file with adequate principal required to exist at the time the service starts?")
    private Boolean required;
    @AttributeDocumentation(value="If this for use server side or client side?")
    private Boolean server;
    @AttributeDocumentation(value="Should generated GSS credentials be wrapped to prevent improper disposal or not?")
    private Boolean wrapGssCredential;
    @AttributeDocumentation(value="The path of the KeyTab to load to obtain the credential.")
    private String path;
    @AttributeDocumentation(value="The name of another previously named path, or of one of the standard paths provided by the system. If 'relative-to' is provided, the value of the 'path' attribute is treated as relative to the path specified by this attribute.")
    private String relativeTo;

    public KerberosSecurityFactory(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="debug")
    public Boolean debug() {
        return this.debug;
    }

    public T debug(Boolean value) {
        Boolean oldValue = this.debug;
        this.debug = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("debug", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="mechanism-names")
    public List<String> mechanismNames() {
        return this.mechanismNames;
    }

    public T mechanismNames(List<String> value) {
        List<String> oldValue = this.mechanismNames;
        this.mechanismNames = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("mechanismNames", oldValue, value);
        }
        return (T)this;
    }

    public T mechanismName(String value) {
        if (this.mechanismNames == null) {
            this.mechanismNames = new ArrayList<String>();
        }
        this.mechanismNames.add(value);
        return (T)this;
    }

    public T mechanismNames(String ... args) {
        this.mechanismNames(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="mechanism-oids")
    public List<String> mechanismOids() {
        return this.mechanismOids;
    }

    public T mechanismOids(List<String> value) {
        List<String> oldValue = this.mechanismOids;
        this.mechanismOids = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("mechanismOids", oldValue, value);
        }
        return (T)this;
    }

    public T mechanismOid(String value) {
        if (this.mechanismOids == null) {
            this.mechanismOids = new ArrayList<String>();
        }
        this.mechanismOids.add(value);
        return (T)this;
    }

    public T mechanismOids(String ... args) {
        this.mechanismOids(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="minimum-remaining-lifetime")
    public Integer minimumRemainingLifetime() {
        return this.minimumRemainingLifetime;
    }

    public T minimumRemainingLifetime(Integer value) {
        Integer oldValue = this.minimumRemainingLifetime;
        this.minimumRemainingLifetime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minimumRemainingLifetime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="obtain-kerberos-ticket")
    public Boolean obtainKerberosTicket() {
        return this.obtainKerberosTicket;
    }

    public T obtainKerberosTicket(Boolean value) {
        Boolean oldValue = this.obtainKerberosTicket;
        this.obtainKerberosTicket = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("obtainKerberosTicket", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="options")
    public Map options() {
        return this.options;
    }

    public T options(Map value) {
        Map oldValue = this.options;
        this.options = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("options", oldValue, value);
        }
        return (T)this;
    }

    public T option(String key, Object value) {
        if (this.options == null) {
            this.options = new HashMap();
        }
        this.options.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="principal")
    public String principal() {
        return this.principal;
    }

    public T principal(String value) {
        String oldValue = this.principal;
        this.principal = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("principal", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-lifetime")
    public Integer requestLifetime() {
        return this.requestLifetime;
    }

    public T requestLifetime(Integer value) {
        Integer oldValue = this.requestLifetime;
        this.requestLifetime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requestLifetime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="required")
    public Boolean required() {
        return this.required;
    }

    public T required(Boolean value) {
        Boolean oldValue = this.required;
        this.required = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("required", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server")
    public Boolean server() {
        return this.server;
    }

    public T server(Boolean value) {
        Boolean oldValue = this.server;
        this.server = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("server", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wrap-gss-credential")
    public Boolean wrapGssCredential() {
        return this.wrapGssCredential;
    }

    public T wrapGssCredential(Boolean value) {
        Boolean oldValue = this.wrapGssCredential;
        this.wrapGssCredential = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wrapGssCredential", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="path")
    public String path() {
        return this.path;
    }

    public T path(String value) {
        String oldValue = this.path;
        this.path = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("path", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="relative-to")
    public String relativeTo() {
        return this.relativeTo;
    }

    public T relativeTo(String value) {
        String oldValue = this.relativeTo;
        this.relativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("relativeTo", oldValue, value);
        }
        return (T)this;
    }
}

