/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.messaging.activemq.FactoryType;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/connection-factory=*")
@ResourceType(value="connection-factory")
public class ConnectionFactory<T extends ConnectionFactory<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Whether or not message grouping is automatically used")
    private Boolean autoGroup;
    @AttributeDocumentation(value="True to set block on acknowledge.")
    private Boolean blockOnAcknowledge;
    @AttributeDocumentation(value="True to set block on durable send.")
    private Boolean blockOnDurableSend;
    @AttributeDocumentation(value="True to set block on non durable send.")
    private Boolean blockOnNonDurableSend;
    @AttributeDocumentation(value="True to cache large messages.")
    private Boolean cacheLargeMessageClient;
    @AttributeDocumentation(value="The timeout to use when fail over is in process (in ms).")
    private Long callFailoverTimeout;
    @AttributeDocumentation(value="The call time out.")
    private Long callTimeout;
    @AttributeDocumentation(value="The client failure check period.")
    private Long clientFailureCheckPeriod;
    @AttributeDocumentation(value="The client id.")
    private String clientId;
    @AttributeDocumentation(value="Whether large messages should be compressed.")
    private Boolean compressLargeMessages;
    @AttributeDocumentation(value="The confirmation window size.")
    private Integer confirmationWindowSize;
    @AttributeDocumentation(value="Name of a class implementing a client-side load balancing policy that a client can use to load balance sessions across different nodes in a cluster.")
    private String connectionLoadBalancingPolicyClassName;
    @AttributeDocumentation(value="The connection ttl.")
    private Long connectionTtl;
    @AttributeDocumentation(value="Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.")
    private List<String> connectors;
    @AttributeDocumentation(value="The consumer max rate.")
    private Integer consumerMaxRate;
    @AttributeDocumentation(value="The consumer window size.")
    private Integer consumerWindowSize;
    @AttributeDocumentation(value="A list of class names (separated by whitespaces) that are black-listed to be used in serialization of JMS ObjectMessage.")
    private List<String> deserializationBlackList;
    @AttributeDocumentation(value="A list of class names (separated by whitespaces) that are white-listed to be used in serialization of JMS ObjectMessage.")
    private List<String> deserializationWhiteList;
    @AttributeDocumentation(value="The discovery group name.")
    private String discoveryGroup;
    @AttributeDocumentation(value="The dups ok batch size.")
    private Integer dupsOkBatchSize;
    @AttributeDocumentation(value="The jndi names the connection factory should be bound to.")
    private List<String> entries;
    @AttributeDocumentation(value="The type of connection factory.")
    private FactoryType factoryType;
    @AttributeDocumentation(value="True to fail over on initial connection.")
    private Boolean failoverOnInitialConnection;
    @AttributeDocumentation(value="The group id.")
    private String groupId;
    @AttributeDocumentation(value="Whether the connection factory supports High Availability.")
    private Boolean ha;
    @AttributeDocumentation(value="The initial size of messages created through this factory.")
    private Integer initialMessagePacketSize;
    @AttributeDocumentation(value="The max retry interval.")
    private Long maxRetryInterval;
    @AttributeDocumentation(value="The min large message size.")
    private Integer minLargeMessageSize;
    @AttributeDocumentation(value="True to pre-acknowledge.")
    private Boolean preAcknowledge;
    @AttributeDocumentation(value="The producer max rate.")
    private Integer producerMaxRate;
    @AttributeDocumentation(value="The producer window size.")
    private Integer producerWindowSize;
    @AttributeDocumentation(value="The protocol manager factory used by this connection factory (it must implement org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory).")
    private String protocolManagerFactory;
    @AttributeDocumentation(value="The reconnect attempts.")
    private Integer reconnectAttempts;
    @AttributeDocumentation(value="The retry interval.")
    private Long retryInterval;
    @AttributeDocumentation(value="The retry interval multiplier.")
    private BigDecimal retryIntervalMultiplier;
    @AttributeDocumentation(value="The scheduled thread pool max size.")
    private Integer scheduledThreadPoolMaxSize;
    @AttributeDocumentation(value="The thread pool max size.")
    private Integer threadPoolMaxSize;
    @AttributeDocumentation(value="The transaction batch size.")
    private Integer transactionBatchSize;
    @AttributeDocumentation(value="True to use global pools.")
    private Boolean useGlobalPools;

    public ConnectionFactory(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="auto-group")
    public Boolean autoGroup() {
        return this.autoGroup;
    }

    public T autoGroup(Boolean value) {
        Boolean oldValue = this.autoGroup;
        this.autoGroup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("autoGroup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="block-on-acknowledge")
    public Boolean blockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    public T blockOnAcknowledge(Boolean value) {
        Boolean oldValue = this.blockOnAcknowledge;
        this.blockOnAcknowledge = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("blockOnAcknowledge", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="block-on-durable-send")
    public Boolean blockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    public T blockOnDurableSend(Boolean value) {
        Boolean oldValue = this.blockOnDurableSend;
        this.blockOnDurableSend = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("blockOnDurableSend", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="block-on-non-durable-send")
    public Boolean blockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    public T blockOnNonDurableSend(Boolean value) {
        Boolean oldValue = this.blockOnNonDurableSend;
        this.blockOnNonDurableSend = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("blockOnNonDurableSend", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cache-large-message-client")
    public Boolean cacheLargeMessageClient() {
        return this.cacheLargeMessageClient;
    }

    public T cacheLargeMessageClient(Boolean value) {
        Boolean oldValue = this.cacheLargeMessageClient;
        this.cacheLargeMessageClient = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cacheLargeMessageClient", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="call-failover-timeout")
    public Long callFailoverTimeout() {
        return this.callFailoverTimeout;
    }

    public T callFailoverTimeout(Long value) {
        Long oldValue = this.callFailoverTimeout;
        this.callFailoverTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("callFailoverTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="call-timeout")
    public Long callTimeout() {
        return this.callTimeout;
    }

    public T callTimeout(Long value) {
        Long oldValue = this.callTimeout;
        this.callTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("callTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-failure-check-period")
    public Long clientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    public T clientFailureCheckPeriod(Long value) {
        Long oldValue = this.clientFailureCheckPeriod;
        this.clientFailureCheckPeriod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientFailureCheckPeriod", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-id")
    public String clientId() {
        return this.clientId;
    }

    public T clientId(String value) {
        String oldValue = this.clientId;
        this.clientId = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientId", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="compress-large-messages")
    public Boolean compressLargeMessages() {
        return this.compressLargeMessages;
    }

    public T compressLargeMessages(Boolean value) {
        Boolean oldValue = this.compressLargeMessages;
        this.compressLargeMessages = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("compressLargeMessages", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="confirmation-window-size")
    public Integer confirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public T confirmationWindowSize(Integer value) {
        Integer oldValue = this.confirmationWindowSize;
        this.confirmationWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("confirmationWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-load-balancing-policy-class-name")
    public String connectionLoadBalancingPolicyClassName() {
        return this.connectionLoadBalancingPolicyClassName;
    }

    public T connectionLoadBalancingPolicyClassName(String value) {
        String oldValue = this.connectionLoadBalancingPolicyClassName;
        this.connectionLoadBalancingPolicyClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionLoadBalancingPolicyClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-ttl")
    public Long connectionTtl() {
        return this.connectionTtl;
    }

    public T connectionTtl(Long value) {
        Long oldValue = this.connectionTtl;
        this.connectionTtl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionTtl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connectors")
    public List<String> connectors() {
        return this.connectors;
    }

    public T connectors(List<String> value) {
        List<String> oldValue = this.connectors;
        this.connectors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectors", oldValue, value);
        }
        return (T)this;
    }

    public T connector(String value) {
        if (this.connectors == null) {
            this.connectors = new ArrayList<String>();
        }
        this.connectors.add(value);
        return (T)this;
    }

    public T connectors(String ... args) {
        this.connectors(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="consumer-max-rate")
    public Integer consumerMaxRate() {
        return this.consumerMaxRate;
    }

    public T consumerMaxRate(Integer value) {
        Integer oldValue = this.consumerMaxRate;
        this.consumerMaxRate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("consumerMaxRate", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="consumer-window-size")
    public Integer consumerWindowSize() {
        return this.consumerWindowSize;
    }

    public T consumerWindowSize(Integer value) {
        Integer oldValue = this.consumerWindowSize;
        this.consumerWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("consumerWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="deserialization-black-list")
    public List<String> deserializationBlackList() {
        return this.deserializationBlackList;
    }

    public T deserializationBlackList(List<String> value) {
        List<String> oldValue = this.deserializationBlackList;
        this.deserializationBlackList = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("deserializationBlackList", oldValue, value);
        }
        return (T)this;
    }

    public T deserializationBlackList(String value) {
        if (this.deserializationBlackList == null) {
            this.deserializationBlackList = new ArrayList<String>();
        }
        this.deserializationBlackList.add(value);
        return (T)this;
    }

    public T deserializationBlackList(String ... args) {
        this.deserializationBlackList(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="deserialization-white-list")
    public List<String> deserializationWhiteList() {
        return this.deserializationWhiteList;
    }

    public T deserializationWhiteList(List<String> value) {
        List<String> oldValue = this.deserializationWhiteList;
        this.deserializationWhiteList = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("deserializationWhiteList", oldValue, value);
        }
        return (T)this;
    }

    public T deserializationWhiteList(String value) {
        if (this.deserializationWhiteList == null) {
            this.deserializationWhiteList = new ArrayList<String>();
        }
        this.deserializationWhiteList.add(value);
        return (T)this;
    }

    public T deserializationWhiteList(String ... args) {
        this.deserializationWhiteList(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="discovery-group")
    public String discoveryGroup() {
        return this.discoveryGroup;
    }

    public T discoveryGroup(String value) {
        String oldValue = this.discoveryGroup;
        this.discoveryGroup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("discoveryGroup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="dups-ok-batch-size")
    public Integer dupsOkBatchSize() {
        return this.dupsOkBatchSize;
    }

    public T dupsOkBatchSize(Integer value) {
        Integer oldValue = this.dupsOkBatchSize;
        this.dupsOkBatchSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dupsOkBatchSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="entries")
    public List<String> entries() {
        return this.entries;
    }

    public T entries(List<String> value) {
        List<String> oldValue = this.entries;
        this.entries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("entries", oldValue, value);
        }
        return (T)this;
    }

    public T entry(String value) {
        if (this.entries == null) {
            this.entries = new ArrayList<String>();
        }
        this.entries.add(value);
        return (T)this;
    }

    public T entries(String ... args) {
        this.entries(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="factory-type")
    public FactoryType factoryType() {
        return this.factoryType;
    }

    public T factoryType(FactoryType value) {
        FactoryType oldValue = this.factoryType;
        this.factoryType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("factoryType", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="failover-on-initial-connection")
    public Boolean failoverOnInitialConnection() {
        return this.failoverOnInitialConnection;
    }

    public T failoverOnInitialConnection(Boolean value) {
        Boolean oldValue = this.failoverOnInitialConnection;
        this.failoverOnInitialConnection = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("failoverOnInitialConnection", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="group-id")
    public String groupId() {
        return this.groupId;
    }

    public T groupId(String value) {
        String oldValue = this.groupId;
        this.groupId = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("groupId", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ha")
    public Boolean ha() {
        return this.ha;
    }

    public T ha(Boolean value) {
        Boolean oldValue = this.ha;
        this.ha = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ha", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="initial-message-packet-size")
    public Integer initialMessagePacketSize() {
        return this.initialMessagePacketSize;
    }

    public T initialMessagePacketSize(Integer value) {
        Integer oldValue = this.initialMessagePacketSize;
        this.initialMessagePacketSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("initialMessagePacketSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-retry-interval")
    public Long maxRetryInterval() {
        return this.maxRetryInterval;
    }

    public T maxRetryInterval(Long value) {
        Long oldValue = this.maxRetryInterval;
        this.maxRetryInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRetryInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="min-large-message-size")
    public Integer minLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    public T minLargeMessageSize(Integer value) {
        Integer oldValue = this.minLargeMessageSize;
        this.minLargeMessageSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minLargeMessageSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pre-acknowledge")
    public Boolean preAcknowledge() {
        return this.preAcknowledge;
    }

    public T preAcknowledge(Boolean value) {
        Boolean oldValue = this.preAcknowledge;
        this.preAcknowledge = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preAcknowledge", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="producer-max-rate")
    public Integer producerMaxRate() {
        return this.producerMaxRate;
    }

    public T producerMaxRate(Integer value) {
        Integer oldValue = this.producerMaxRate;
        this.producerMaxRate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("producerMaxRate", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="producer-window-size")
    public Integer producerWindowSize() {
        return this.producerWindowSize;
    }

    public T producerWindowSize(Integer value) {
        Integer oldValue = this.producerWindowSize;
        this.producerWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("producerWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocol-manager-factory")
    public String protocolManagerFactory() {
        return this.protocolManagerFactory;
    }

    public T protocolManagerFactory(String value) {
        String oldValue = this.protocolManagerFactory;
        this.protocolManagerFactory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocolManagerFactory", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reconnect-attempts")
    public Integer reconnectAttempts() {
        return this.reconnectAttempts;
    }

    public T reconnectAttempts(Integer value) {
        Integer oldValue = this.reconnectAttempts;
        this.reconnectAttempts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reconnectAttempts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="retry-interval")
    public Long retryInterval() {
        return this.retryInterval;
    }

    public T retryInterval(Long value) {
        Long oldValue = this.retryInterval;
        this.retryInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("retryInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="retry-interval-multiplier")
    public BigDecimal retryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public T retryIntervalMultiplier(BigDecimal value) {
        BigDecimal oldValue = this.retryIntervalMultiplier;
        this.retryIntervalMultiplier = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("retryIntervalMultiplier", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scheduled-thread-pool-max-size")
    public Integer scheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    public T scheduledThreadPoolMaxSize(Integer value) {
        Integer oldValue = this.scheduledThreadPoolMaxSize;
        this.scheduledThreadPoolMaxSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scheduledThreadPoolMaxSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="thread-pool-max-size")
    public Integer threadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    public T threadPoolMaxSize(Integer value) {
        Integer oldValue = this.threadPoolMaxSize;
        this.threadPoolMaxSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadPoolMaxSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transaction-batch-size")
    public Integer transactionBatchSize() {
        return this.transactionBatchSize;
    }

    public T transactionBatchSize(Integer value) {
        Integer oldValue = this.transactionBatchSize;
        this.transactionBatchSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transactionBatchSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-global-pools")
    public Boolean useGlobalPools() {
        return this.useGlobalPools;
    }

    public T useGlobalPools(Boolean value) {
        Boolean oldValue = this.useGlobalPools;
        this.useGlobalPools = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useGlobalPools", oldValue, value);
        }
        return (T)this;
    }
}

