/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/discovery-group=*")
@ResourceType(value="discovery-group")
public class DiscoveryGroup<T extends DiscoveryGroup<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Period, in ms, to wait for an initial broadcast to give us at least one node in the cluster.")
    private Long initialWaitTimeout;
    @AttributeDocumentation(value="The name used by a JGroups channel to join a cluster.")
    private String jgroupsChannel;
    @AttributeDocumentation(value="The name of a stack defined in the org.jboss.as.clustering.jgroups subsystem that is used to form a cluster.")
    private String jgroupsStack;
    @AttributeDocumentation(value="Period the discovery group waits after receiving the last broadcast from a particular server before removing that server's connector pair entry from its list.")
    private Long refreshTimeout;
    @AttributeDocumentation(value="The discovery group socket binding.")
    private String socketBinding;

    public DiscoveryGroup(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="initial-wait-timeout")
    public Long initialWaitTimeout() {
        return this.initialWaitTimeout;
    }

    public T initialWaitTimeout(Long value) {
        Long oldValue = this.initialWaitTimeout;
        this.initialWaitTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("initialWaitTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jgroups-channel")
    public String jgroupsChannel() {
        return this.jgroupsChannel;
    }

    public T jgroupsChannel(String value) {
        String oldValue = this.jgroupsChannel;
        this.jgroupsChannel = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jgroupsChannel", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jgroups-stack")
    public String jgroupsStack() {
        return this.jgroupsStack;
    }

    public T jgroupsStack(String value) {
        String oldValue = this.jgroupsStack;
        this.jgroupsStack = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jgroupsStack", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="refresh-timeout")
    public Long refreshTimeout() {
        return this.refreshTimeout;
    }

    public T refreshTimeout(Long value) {
        Long oldValue = this.refreshTimeout;
        this.refreshTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("refreshTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }
}

