/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.messaging.activemq.server.Role;
import org.wildfly.swarm.config.messaging.activemq.server.RoleConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.RoleSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=messaging-activemq/server=*/security-setting=*")
@ResourceType(value="security-setting")
public class SecuritySetting<T extends SecuritySetting<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private SecuritySettingResources subresources = new SecuritySettingResources();

    public SecuritySetting(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public SecuritySettingResources subresources() {
        return this.subresources;
    }

    public T roles(List<Role> value) {
        this.subresources.roles = value;
        return (T)this;
    }

    public T role(Role value) {
        this.subresources.roles.add(value);
        return (T)this;
    }

    public T role(String childKey, RoleConsumer consumer) {
        Role child = new Role(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.role(child);
        return (T)this;
    }

    public T role(String childKey) {
        this.role(childKey, null);
        return (T)this;
    }

    public T role(RoleSupplier supplier) {
        this.role(supplier.get());
        return (T)this;
    }

    public static class SecuritySettingResources {
        @ResourceDocumentation(value="A security role.")
        @SubresourceInfo(value="role")
        private List<Role> roles = new ArrayList<Role>();

        @Subresource
        public List<Role> roles() {
            return this.roles;
        }

        public Role role(String key) {
            return this.roles.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

