/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.remoting;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.remoting.Property;
import org.wildfly.swarm.config.remoting.PropertyConsumer;
import org.wildfly.swarm.config.remoting.PropertySupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=remoting/remote-outbound-connection=*")
@ResourceType(value="remote-outbound-connection")
public class RemoteOutboundConnection<T extends RemoteOutboundConnection<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private RemoteOutboundConnectionResources subresources = new RemoteOutboundConnectionResources();
    @AttributeDocumentation(value="Reference to the authentication context instance containing the configuration for outbound connections.")
    private String authenticationContext;
    @AttributeDocumentation(value="Name of the outbound-socket-binding which will be used to determine the destination address and port for the connection.")
    private String outboundSocketBindingRef;
    @AttributeDocumentation(value="The protocol to use for the remote connection.")
    private String protocol;
    @AttributeDocumentation(value="Reference to the security realm to use to obtain the password and SSL configuration.")
    private String securityRealm;
    @AttributeDocumentation(value="The user name to use when authenticating against the remote server.")
    private String username;

    public RemoteOutboundConnection(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public RemoteOutboundConnectionResources subresources() {
        return this.subresources;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-context")
    public String authenticationContext() {
        return this.authenticationContext;
    }

    public T authenticationContext(String value) {
        String oldValue = this.authenticationContext;
        this.authenticationContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="outbound-socket-binding-ref")
    public String outboundSocketBindingRef() {
        return this.outboundSocketBindingRef;
    }

    public T outboundSocketBindingRef(String value) {
        String oldValue = this.outboundSocketBindingRef;
        this.outboundSocketBindingRef = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("outboundSocketBindingRef", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocol")
    public String protocol() {
        return this.protocol;
    }

    public T protocol(String value) {
        String oldValue = this.protocol;
        this.protocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    public T securityRealm(String value) {
        String oldValue = this.securityRealm;
        this.securityRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="username")
    public String username() {
        return this.username;
    }

    public T username(String value) {
        String oldValue = this.username;
        this.username = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("username", oldValue, value);
        }
        return (T)this;
    }

    public static class RemoteOutboundConnectionResources {
        @ResourceDocumentation(value="Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.")
        @SubresourceInfo(value="property")
        private List<Property> properties = new ArrayList<Property>();

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        public Property property(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

