package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.ejb3.ApplicationSecurityDomainConsumer;
import org.wildfly.swarm.config.ejb3.ApplicationSecurityDomainSupplier;
import org.wildfly.swarm.config.ejb3.ApplicationSecurityDomain;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.ejb3.StrictMaxBeanInstancePoolConsumer;
import org.wildfly.swarm.config.ejb3.StrictMaxBeanInstancePoolSupplier;
import org.wildfly.swarm.config.ejb3.StrictMaxBeanInstancePool;
import org.wildfly.swarm.config.ejb3.CacheConsumer;
import org.wildfly.swarm.config.ejb3.CacheSupplier;
import org.wildfly.swarm.config.ejb3.Cache;
import org.wildfly.swarm.config.ejb3.RemotingProfileConsumer;
import org.wildfly.swarm.config.ejb3.RemotingProfileSupplier;
import org.wildfly.swarm.config.ejb3.RemotingProfile;
import org.wildfly.swarm.config.ejb3.ClusterPassivationStoreConsumer;
import org.wildfly.swarm.config.ejb3.ClusterPassivationStoreSupplier;
import org.wildfly.swarm.config.ejb3.ClusterPassivationStore;
import org.wildfly.swarm.config.ejb3.PassivationStoreConsumer;
import org.wildfly.swarm.config.ejb3.PassivationStoreSupplier;
import org.wildfly.swarm.config.ejb3.PassivationStore;
import org.wildfly.swarm.config.ejb3.MDBDeliveryGroupConsumer;
import org.wildfly.swarm.config.ejb3.MDBDeliveryGroupSupplier;
import org.wildfly.swarm.config.ejb3.MDBDeliveryGroup;
import org.wildfly.swarm.config.ejb3.ThreadPoolConsumer;
import org.wildfly.swarm.config.ejb3.ThreadPoolSupplier;
import org.wildfly.swarm.config.ejb3.ThreadPool;
import org.wildfly.swarm.config.ejb3.FilePassivationStoreConsumer;
import org.wildfly.swarm.config.ejb3.FilePassivationStoreSupplier;
import org.wildfly.swarm.config.ejb3.FilePassivationStore;
import org.wildfly.swarm.config.ejb3.TimerService;
import org.wildfly.swarm.config.ejb3.TimerServiceConsumer;
import org.wildfly.swarm.config.ejb3.TimerServiceSupplier;
import org.wildfly.swarm.config.ejb3.RemoteService;
import org.wildfly.swarm.config.ejb3.RemoteServiceConsumer;
import org.wildfly.swarm.config.ejb3.RemoteServiceSupplier;
import org.wildfly.swarm.config.ejb3.AsyncService;
import org.wildfly.swarm.config.ejb3.AsyncServiceConsumer;
import org.wildfly.swarm.config.ejb3.AsyncServiceSupplier;
import org.wildfly.swarm.config.ejb3.IdentityService;
import org.wildfly.swarm.config.ejb3.IdentityServiceConsumer;
import org.wildfly.swarm.config.ejb3.IdentityServiceSupplier;
import org.wildfly.swarm.config.ejb3.IIOPService;
import org.wildfly.swarm.config.ejb3.IIOPServiceConsumer;
import org.wildfly.swarm.config.ejb3.IIOPServiceSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of the ejb3 subsystem.
 */
@Address("/subsystem=ejb3")
@ResourceType("subsystem")
@Implicit
public class EJB3<T extends EJB3<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private EJB3Resources subresources = new EJB3Resources();
	@AttributeDocumentation("If this is true then regular expressions can be used in interceptor bindings to allow interceptors to be mapped to all beans that match the regular expression")
	private Boolean allowEjbNameRegex;
	@AttributeDocumentation("Name of the default stateful bean cache, which will be applicable to all clustered stateful EJBs, unless overridden at the deployment or bean level")
	private String defaultClusteredSfsbCache;
	@AttributeDocumentation("The default distinct name that is applied to every EJB deployed on this server")
	private String defaultDistinctName;
	@AttributeDocumentation("Name of the default entity bean instance pool, which will be applicable to all entity beans, unless overridden at the deployment or bean level")
	private String defaultEntityBeanInstancePool;
	@AttributeDocumentation("If set to true entity beans will use optimistic locking by default")
	private Boolean defaultEntityBeanOptimisticLocking;
	@AttributeDocumentation("Name of the default MDB instance pool, which will be applicable to all MDBs, unless overridden at the deployment or bean level")
	private String defaultMdbInstancePool;
	@AttributeDocumentation("If this is set to true then methods on an EJB with a security domain specified or with other methods with security metadata will have an implicit @DenyAll unless other security metadata is present")
	private Boolean defaultMissingMethodPermissionsDenyAccess;
	@AttributeDocumentation("Name of the default resource adapter name that will be used by MDBs, unless overridden at the deployment or bean level")
	private String defaultResourceAdapterName;
	@AttributeDocumentation("The default security domain that will be used for EJBs if the bean doesn't explicitly specify one")
	private String defaultSecurityDomain;
	@AttributeDocumentation("Name of the default stateful bean cache, which will be applicable to all stateful EJBs, unless overridden at the deployment or bean level")
	private String defaultSfsbCache;
	@AttributeDocumentation("Name of the default stateful bean cache, which will be applicable to all stateful EJBs which have passivation disabled. Each deployment or EJB can optionally override this cache name.")
	private String defaultSfsbPassivationDisabledCache;
	@AttributeDocumentation("The default access timeout for singleton beans")
	private Long defaultSingletonBeanAccessTimeout;
	@AttributeDocumentation("Name of the default stateless bean instance pool, which will be applicable to all stateless EJBs, unless overridden at the deployment or bean level")
	private String defaultSlsbInstancePool;
	@AttributeDocumentation("The default access timeout for stateful beans")
	private Long defaultStatefulBeanAccessTimeout;
	@AttributeDocumentation("This deprecated attribute has no effect and will be removed in a future release; it may never be set to a \"false\" value")
	private Boolean disableDefaultEjbPermissions;
	@AttributeDocumentation("Enabling txn graceful shutdown will make the server wait for active EJB-related transactions to complete before suspending. For that reason, if the server is running on a cluster, the suspending cluster node may receive ejb requests until all active transactions are complete. To avoid this behavior, omit this tag.")
	private Boolean enableGracefulTxnShutdown;
	@AttributeDocumentation("If set to true, enable the collection of invocation statistics. Deprecated in favour of \"statistics-enabled\"")
	private Boolean enableStatistics;
	@AttributeDocumentation("If set to false, the parameters to invocations on remote interface of an EJB, will be passed by reference. Else, the parameters will be passed by value.")
	private Boolean inVmRemoteInterfaceInvocationPassByValue;
	@AttributeDocumentation("If this is true then all EJB system (not application) exceptions will be logged. The EJB spec mandates this behaviour, however it is not recommended as it will often result in exceptions being logged twice (once by the EJB and once by the calling code)")
	private Boolean logSystemExceptions;
	@AttributeDocumentation("If set to true, enable the collection of invocation statistics.")
	private Boolean statisticsEnabled;

	public EJB3() {
		super();
		this.key = "ejb3";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public EJB3Resources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ApplicationSecurityDomain objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ApplicationSecurityDomain objects.
	 */
	@SuppressWarnings("unchecked")
	public T applicationSecurityDomains(
			java.util.List<ApplicationSecurityDomain> value) {
		this.subresources.applicationSecurityDomains = value;
		return (T) this;
	}

	/**
	 * Add the ApplicationSecurityDomain object to the list of subresources
	 * 
	 * @param value
	 *            The ApplicationSecurityDomain to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T applicationSecurityDomain(ApplicationSecurityDomain value) {
		this.subresources.applicationSecurityDomains.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ApplicationSecurityDomain object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ApplicationSecurityDomain resource
	 * @param config
	 *            The ApplicationSecurityDomainConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T applicationSecurityDomain(java.lang.String childKey,
			ApplicationSecurityDomainConsumer consumer) {
		ApplicationSecurityDomain<? extends ApplicationSecurityDomain> child = new ApplicationSecurityDomain<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		applicationSecurityDomain(child);
		return (T) this;
	}

	/**
	 * Create and configure a ApplicationSecurityDomain object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ApplicationSecurityDomain resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T applicationSecurityDomain(java.lang.String childKey) {
		applicationSecurityDomain(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ApplicationSecurityDomain object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T applicationSecurityDomain(
			ApplicationSecurityDomainSupplier supplier) {
		applicationSecurityDomain(supplier.get());
		return (T) this;
	}

	/**
	 * Add all StrictMaxBeanInstancePool objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of StrictMaxBeanInstancePool objects.
	 */
	@SuppressWarnings("unchecked")
	public T strictMaxBeanInstancePools(
			java.util.List<StrictMaxBeanInstancePool> value) {
		this.subresources.strictMaxBeanInstancePools = value;
		return (T) this;
	}

	/**
	 * Add the StrictMaxBeanInstancePool object to the list of subresources
	 * 
	 * @param value
	 *            The StrictMaxBeanInstancePool to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T strictMaxBeanInstancePool(StrictMaxBeanInstancePool value) {
		this.subresources.strictMaxBeanInstancePools.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a StrictMaxBeanInstancePool object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the StrictMaxBeanInstancePool resource
	 * @param config
	 *            The StrictMaxBeanInstancePoolConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T strictMaxBeanInstancePool(java.lang.String childKey,
			StrictMaxBeanInstancePoolConsumer consumer) {
		StrictMaxBeanInstancePool<? extends StrictMaxBeanInstancePool> child = new StrictMaxBeanInstancePool<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		strictMaxBeanInstancePool(child);
		return (T) this;
	}

	/**
	 * Create and configure a StrictMaxBeanInstancePool object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the StrictMaxBeanInstancePool resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T strictMaxBeanInstancePool(java.lang.String childKey) {
		strictMaxBeanInstancePool(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied StrictMaxBeanInstancePool object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T strictMaxBeanInstancePool(
			StrictMaxBeanInstancePoolSupplier supplier) {
		strictMaxBeanInstancePool(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Cache objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Cache objects.
	 */
	@SuppressWarnings("unchecked")
	public T caches(java.util.List<Cache> value) {
		this.subresources.caches = value;
		return (T) this;
	}

	/**
	 * Add the Cache object to the list of subresources
	 * 
	 * @param value
	 *            The Cache to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T cache(Cache value) {
		this.subresources.caches.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Cache object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Cache resource
	 * @param config
	 *            The CacheConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T cache(java.lang.String childKey, CacheConsumer consumer) {
		Cache<? extends Cache> child = new Cache<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		cache(child);
		return (T) this;
	}

	/**
	 * Create and configure a Cache object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Cache resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T cache(java.lang.String childKey) {
		cache(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Cache object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T cache(CacheSupplier supplier) {
		cache(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RemotingProfile objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RemotingProfile objects.
	 */
	@SuppressWarnings("unchecked")
	public T remotingProfiles(java.util.List<RemotingProfile> value) {
		this.subresources.remotingProfiles = value;
		return (T) this;
	}

	/**
	 * Add the RemotingProfile object to the list of subresources
	 * 
	 * @param value
	 *            The RemotingProfile to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remotingProfile(RemotingProfile value) {
		this.subresources.remotingProfiles.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RemotingProfile object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemotingProfile resource
	 * @param config
	 *            The RemotingProfileConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remotingProfile(java.lang.String childKey,
			RemotingProfileConsumer consumer) {
		RemotingProfile<? extends RemotingProfile> child = new RemotingProfile<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		remotingProfile(child);
		return (T) this;
	}

	/**
	 * Create and configure a RemotingProfile object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemotingProfile resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remotingProfile(java.lang.String childKey) {
		remotingProfile(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RemotingProfile object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T remotingProfile(RemotingProfileSupplier supplier) {
		remotingProfile(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ClusterPassivationStore objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ClusterPassivationStore objects.
	 */
	@SuppressWarnings("unchecked")
	public T clusterPassivationStores(
			java.util.List<ClusterPassivationStore> value) {
		this.subresources.clusterPassivationStores = value;
		return (T) this;
	}

	/**
	 * Add the ClusterPassivationStore object to the list of subresources
	 * 
	 * @param value
	 *            The ClusterPassivationStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterPassivationStore(ClusterPassivationStore value) {
		this.subresources.clusterPassivationStores.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ClusterPassivationStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ClusterPassivationStore resource
	 * @param config
	 *            The ClusterPassivationStoreConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterPassivationStore(java.lang.String childKey,
			ClusterPassivationStoreConsumer consumer) {
		ClusterPassivationStore<? extends ClusterPassivationStore> child = new ClusterPassivationStore<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		clusterPassivationStore(child);
		return (T) this;
	}

	/**
	 * Create and configure a ClusterPassivationStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ClusterPassivationStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterPassivationStore(java.lang.String childKey) {
		clusterPassivationStore(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ClusterPassivationStore object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T clusterPassivationStore(ClusterPassivationStoreSupplier supplier) {
		clusterPassivationStore(supplier.get());
		return (T) this;
	}

	/**
	 * Add all PassivationStore objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PassivationStore objects.
	 */
	@SuppressWarnings("unchecked")
	public T passivationStores(java.util.List<PassivationStore> value) {
		this.subresources.passivationStores = value;
		return (T) this;
	}

	/**
	 * Add the PassivationStore object to the list of subresources
	 * 
	 * @param value
	 *            The PassivationStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T passivationStore(PassivationStore value) {
		this.subresources.passivationStores.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PassivationStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PassivationStore resource
	 * @param config
	 *            The PassivationStoreConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T passivationStore(java.lang.String childKey,
			PassivationStoreConsumer consumer) {
		PassivationStore<? extends PassivationStore> child = new PassivationStore<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		passivationStore(child);
		return (T) this;
	}

	/**
	 * Create and configure a PassivationStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PassivationStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T passivationStore(java.lang.String childKey) {
		passivationStore(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PassivationStore object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T passivationStore(PassivationStoreSupplier supplier) {
		passivationStore(supplier.get());
		return (T) this;
	}

	/**
	 * Add all MDBDeliveryGroup objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of MDBDeliveryGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T mdbDeliveryGroups(java.util.List<MDBDeliveryGroup> value) {
		this.subresources.mdbDeliveryGroups = value;
		return (T) this;
	}

	/**
	 * Add the MDBDeliveryGroup object to the list of subresources
	 * 
	 * @param value
	 *            The MDBDeliveryGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mdbDeliveryGroup(MDBDeliveryGroup value) {
		this.subresources.mdbDeliveryGroups.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a MDBDeliveryGroup object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the MDBDeliveryGroup resource
	 * @param config
	 *            The MDBDeliveryGroupConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mdbDeliveryGroup(java.lang.String childKey,
			MDBDeliveryGroupConsumer consumer) {
		MDBDeliveryGroup<? extends MDBDeliveryGroup> child = new MDBDeliveryGroup<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		mdbDeliveryGroup(child);
		return (T) this;
	}

	/**
	 * Create and configure a MDBDeliveryGroup object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the MDBDeliveryGroup resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mdbDeliveryGroup(java.lang.String childKey) {
		mdbDeliveryGroup(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied MDBDeliveryGroup object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T mdbDeliveryGroup(MDBDeliveryGroupSupplier supplier) {
		mdbDeliveryGroup(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ThreadPool objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ThreadPool objects.
	 */
	@SuppressWarnings("unchecked")
	public T threadPools(java.util.List<ThreadPool> value) {
		this.subresources.threadPools = value;
		return (T) this;
	}

	/**
	 * Add the ThreadPool object to the list of subresources
	 * 
	 * @param value
	 *            The ThreadPool to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T threadPool(ThreadPool value) {
		this.subresources.threadPools.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ThreadPool object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ThreadPool resource
	 * @param config
	 *            The ThreadPoolConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T threadPool(java.lang.String childKey, ThreadPoolConsumer consumer) {
		ThreadPool<? extends ThreadPool> child = new ThreadPool<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		threadPool(child);
		return (T) this;
	}

	/**
	 * Create and configure a ThreadPool object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ThreadPool resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T threadPool(java.lang.String childKey) {
		threadPool(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ThreadPool object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T threadPool(ThreadPoolSupplier supplier) {
		threadPool(supplier.get());
		return (T) this;
	}

	/**
	 * Add all FilePassivationStore objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of FilePassivationStore objects.
	 */
	@SuppressWarnings("unchecked")
	public T filePassivationStores(java.util.List<FilePassivationStore> value) {
		this.subresources.filePassivationStores = value;
		return (T) this;
	}

	/**
	 * Add the FilePassivationStore object to the list of subresources
	 * 
	 * @param value
	 *            The FilePassivationStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filePassivationStore(FilePassivationStore value) {
		this.subresources.filePassivationStores.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a FilePassivationStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the FilePassivationStore resource
	 * @param config
	 *            The FilePassivationStoreConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filePassivationStore(java.lang.String childKey,
			FilePassivationStoreConsumer consumer) {
		FilePassivationStore<? extends FilePassivationStore> child = new FilePassivationStore<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		filePassivationStore(child);
		return (T) this;
	}

	/**
	 * Create and configure a FilePassivationStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the FilePassivationStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filePassivationStore(java.lang.String childKey) {
		filePassivationStore(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied FilePassivationStore object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T filePassivationStore(FilePassivationStoreSupplier supplier) {
		filePassivationStore(supplier.get());
		return (T) this;
	}

	/**
	 * The EJB timer service
	 */
	@SuppressWarnings("unchecked")
	public T timerService(TimerService value) {
		this.subresources.timerService = value;
		return (T) this;
	}

	/**
	 * The EJB timer service
	 */
	@SuppressWarnings("unchecked")
	public T timerService(TimerServiceConsumer consumer) {
		TimerService<? extends TimerService> child = new TimerService<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.timerService = child;
		return (T) this;
	}

	/**
	 * The EJB timer service
	 */
	@SuppressWarnings("unchecked")
	public T timerService() {
		TimerService<? extends TimerService> child = new TimerService<>();
		this.subresources.timerService = child;
		return (T) this;
	}

	/**
	 * The EJB timer service
	 */
	@SuppressWarnings("unchecked")
	public T timerService(TimerServiceSupplier supplier) {
		this.subresources.timerService = supplier.get();
		return (T) this;
	}

	/**
	 * The EJB3 Remote Service
	 */
	@SuppressWarnings("unchecked")
	public T remoteService(RemoteService value) {
		this.subresources.remoteService = value;
		return (T) this;
	}

	/**
	 * The EJB3 Remote Service
	 */
	@SuppressWarnings("unchecked")
	public T remoteService(RemoteServiceConsumer consumer) {
		RemoteService<? extends RemoteService> child = new RemoteService<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.remoteService = child;
		return (T) this;
	}

	/**
	 * The EJB3 Remote Service
	 */
	@SuppressWarnings("unchecked")
	public T remoteService() {
		RemoteService<? extends RemoteService> child = new RemoteService<>();
		this.subresources.remoteService = child;
		return (T) this;
	}

	/**
	 * The EJB3 Remote Service
	 */
	@SuppressWarnings("unchecked")
	public T remoteService(RemoteServiceSupplier supplier) {
		this.subresources.remoteService = supplier.get();
		return (T) this;
	}

	/**
	 * The EJB3 Asynchronous Invocation Service
	 */
	@SuppressWarnings("unchecked")
	public T asyncService(AsyncService value) {
		this.subresources.asyncService = value;
		return (T) this;
	}

	/**
	 * The EJB3 Asynchronous Invocation Service
	 */
	@SuppressWarnings("unchecked")
	public T asyncService(AsyncServiceConsumer consumer) {
		AsyncService<? extends AsyncService> child = new AsyncService<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.asyncService = child;
		return (T) this;
	}

	/**
	 * The EJB3 Asynchronous Invocation Service
	 */
	@SuppressWarnings("unchecked")
	public T asyncService() {
		AsyncService<? extends AsyncService> child = new AsyncService<>();
		this.subresources.asyncService = child;
		return (T) this;
	}

	/**
	 * The EJB3 Asynchronous Invocation Service
	 */
	@SuppressWarnings("unchecked")
	public T asyncService(AsyncServiceSupplier supplier) {
		this.subresources.asyncService = supplier.get();
		return (T) this;
	}

	/**
	 * Identity definition for security identity propagation
	 */
	@SuppressWarnings("unchecked")
	public T identityService(IdentityService value) {
		this.subresources.identityService = value;
		return (T) this;
	}

	/**
	 * Identity definition for security identity propagation
	 */
	@SuppressWarnings("unchecked")
	public T identityService(IdentityServiceConsumer consumer) {
		IdentityService<? extends IdentityService> child = new IdentityService<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.identityService = child;
		return (T) this;
	}

	/**
	 * Identity definition for security identity propagation
	 */
	@SuppressWarnings("unchecked")
	public T identityService() {
		IdentityService<? extends IdentityService> child = new IdentityService<>();
		this.subresources.identityService = child;
		return (T) this;
	}

	/**
	 * Identity definition for security identity propagation
	 */
	@SuppressWarnings("unchecked")
	public T identityService(IdentityServiceSupplier supplier) {
		this.subresources.identityService = supplier.get();
		return (T) this;
	}

	/**
	 * The IIOP service
	 */
	@SuppressWarnings("unchecked")
	public T iiopService(IIOPService value) {
		this.subresources.iiopService = value;
		return (T) this;
	}

	/**
	 * The IIOP service
	 */
	@SuppressWarnings("unchecked")
	public T iiopService(IIOPServiceConsumer consumer) {
		IIOPService<? extends IIOPService> child = new IIOPService<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.iiopService = child;
		return (T) this;
	}

	/**
	 * The IIOP service
	 */
	@SuppressWarnings("unchecked")
	public T iiopService() {
		IIOPService<? extends IIOPService> child = new IIOPService<>();
		this.subresources.iiopService = child;
		return (T) this;
	}

	/**
	 * The IIOP service
	 */
	@SuppressWarnings("unchecked")
	public T iiopService(IIOPServiceSupplier supplier) {
		this.subresources.iiopService = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for EJB3
	 */
	public static class EJB3Resources {
		/**
		 * A mapping from a security domain referenced in a deployed application
		 */
		@ResourceDocumentation("A mapping from a security domain referenced in a deployed application")
		@SubresourceInfo("applicationSecurityDomain")
		private List<ApplicationSecurityDomain> applicationSecurityDomains = new java.util.ArrayList<>();
		/**
		 * A bean instance pool with a strict upper limit
		 */
		@ResourceDocumentation("A bean instance pool with a strict upper limit")
		@SubresourceInfo("strictMaxBeanInstancePool")
		private List<StrictMaxBeanInstancePool> strictMaxBeanInstancePools = new java.util.ArrayList<>();
		/**
		 * A SFSB cache
		 */
		@ResourceDocumentation("A SFSB cache")
		@SubresourceInfo("cache")
		private List<Cache> caches = new java.util.ArrayList<>();
		/**
		 * A remoting profile
		 */
		@ResourceDocumentation("A remoting profile")
		@SubresourceInfo("remotingProfile")
		private List<RemotingProfile> remotingProfiles = new java.util.ArrayList<>();
		/**
		 * A clustered passivation store
		 */
		@ResourceDocumentation("A clustered passivation store")
		@SubresourceInfo("clusterPassivationStore")
		private List<ClusterPassivationStore> clusterPassivationStores = new java.util.ArrayList<>();
		/**
		 * A passivation store
		 */
		@ResourceDocumentation("A passivation store")
		@SubresourceInfo("passivationStore")
		private List<PassivationStore> passivationStores = new java.util.ArrayList<>();
		/**
		 * Delivery group to manage delivery for mdbs
		 */
		@ResourceDocumentation("Delivery group to manage delivery for mdbs")
		@SubresourceInfo("mdbDeliveryGroup")
		private List<MDBDeliveryGroup> mdbDeliveryGroups = new java.util.ArrayList<>();
		/**
		 * A thread pool executor with an unbounded queue. Such a thread pool
		 * has a core size and a queue with no upper bound. When a task is
		 * submitted, if the number of running threads is less than the core
		 * size, a new thread is created. Otherwise, the task is placed in
		 * queue. If too many tasks are allowed to be submitted to this type of
		 * executor, an out of memory condition may occur.
		 */
		@ResourceDocumentation("A thread pool executor with an unbounded queue.  Such a thread pool has a core size and a queue with no upper bound.  When a task is submitted, if the number of running threads is less than the core size, a new thread is created.  Otherwise, the task is placed in queue.  If too many tasks are allowed to be submitted to this type of executor, an out of memory condition may occur.")
		@SubresourceInfo("threadPool")
		private List<ThreadPool> threadPools = new java.util.ArrayList<>();
		/**
		 * A file system based passivation store
		 */
		@ResourceDocumentation("A file system based passivation store")
		@SubresourceInfo("filePassivationStore")
		private List<FilePassivationStore> filePassivationStores = new java.util.ArrayList<>();
		@SingletonResource
		@ResourceDocumentation("The EJB timer service")
		private TimerService timerService;
		@SingletonResource
		@ResourceDocumentation("The EJB3 Remote Service")
		private RemoteService remoteService;
		@SingletonResource
		@ResourceDocumentation("The EJB3 Asynchronous Invocation Service")
		private AsyncService asyncService;
		@SingletonResource
		@ResourceDocumentation("Identity definition for security identity propagation")
		private IdentityService identityService;
		@SingletonResource
		@ResourceDocumentation("The IIOP service")
		private IIOPService iiopService;

		/**
		 * Get the list of ApplicationSecurityDomain resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ApplicationSecurityDomain> applicationSecurityDomains() {
			return this.applicationSecurityDomains;
		}

		public ApplicationSecurityDomain applicationSecurityDomain(
				java.lang.String key) {
			return this.applicationSecurityDomains.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of StrictMaxBeanInstancePool resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<StrictMaxBeanInstancePool> strictMaxBeanInstancePools() {
			return this.strictMaxBeanInstancePools;
		}

		public StrictMaxBeanInstancePool strictMaxBeanInstancePool(
				java.lang.String key) {
			return this.strictMaxBeanInstancePools.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Cache resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Cache> caches() {
			return this.caches;
		}

		public Cache cache(java.lang.String key) {
			return this.caches.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of RemotingProfile resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RemotingProfile> remotingProfiles() {
			return this.remotingProfiles;
		}

		public RemotingProfile remotingProfile(java.lang.String key) {
			return this.remotingProfiles.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ClusterPassivationStore resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ClusterPassivationStore> clusterPassivationStores() {
			return this.clusterPassivationStores;
		}

		public ClusterPassivationStore clusterPassivationStore(
				java.lang.String key) {
			return this.clusterPassivationStores.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of PassivationStore resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PassivationStore> passivationStores() {
			return this.passivationStores;
		}

		public PassivationStore passivationStore(java.lang.String key) {
			return this.passivationStores.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of MDBDeliveryGroup resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<MDBDeliveryGroup> mdbDeliveryGroups() {
			return this.mdbDeliveryGroups;
		}

		public MDBDeliveryGroup mdbDeliveryGroup(java.lang.String key) {
			return this.mdbDeliveryGroups.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ThreadPool resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ThreadPool> threadPools() {
			return this.threadPools;
		}

		public ThreadPool threadPool(java.lang.String key) {
			return this.threadPools.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of FilePassivationStore resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<FilePassivationStore> filePassivationStores() {
			return this.filePassivationStores;
		}

		public FilePassivationStore filePassivationStore(java.lang.String key) {
			return this.filePassivationStores.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * The EJB timer service
		 */
		@Subresource
		public TimerService timerService() {
			return this.timerService;
		}

		/**
		 * The EJB3 Remote Service
		 */
		@Subresource
		public RemoteService remoteService() {
			return this.remoteService;
		}

		/**
		 * The EJB3 Asynchronous Invocation Service
		 */
		@Subresource
		public AsyncService asyncService() {
			return this.asyncService;
		}

		/**
		 * Identity definition for security identity propagation
		 */
		@Subresource
		public IdentityService identityService() {
			return this.identityService;
		}

		/**
		 * The IIOP service
		 */
		@Subresource
		public IIOPService iiopService() {
			return this.iiopService;
		}
	}

	/**
	 * If this is true then regular expressions can be used in interceptor
	 * bindings to allow interceptors to be mapped to all beans that match the
	 * regular expression
	 */
	@ModelNodeBinding(detypedName = "allow-ejb-name-regex")
	public Boolean allowEjbNameRegex() {
		return this.allowEjbNameRegex;
	}

	/**
	 * If this is true then regular expressions can be used in interceptor
	 * bindings to allow interceptors to be mapped to all beans that match the
	 * regular expression
	 */
	@SuppressWarnings("unchecked")
	public T allowEjbNameRegex(java.lang.Boolean value) {
		Object oldValue = this.allowEjbNameRegex;
		this.allowEjbNameRegex = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowEjbNameRegex", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the default stateful bean cache, which will be applicable to all
	 * clustered stateful EJBs, unless overridden at the deployment or bean
	 * level
	 */
	@ModelNodeBinding(detypedName = "default-clustered-sfsb-cache")
	public String defaultClusteredSfsbCache() {
		return this.defaultClusteredSfsbCache;
	}

	/**
	 * Name of the default stateful bean cache, which will be applicable to all
	 * clustered stateful EJBs, unless overridden at the deployment or bean
	 * level
	 */
	@SuppressWarnings("unchecked")
	public T defaultClusteredSfsbCache(java.lang.String value) {
		Object oldValue = this.defaultClusteredSfsbCache;
		this.defaultClusteredSfsbCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultClusteredSfsbCache", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The default distinct name that is applied to every EJB deployed on this
	 * server
	 */
	@ModelNodeBinding(detypedName = "default-distinct-name")
	public String defaultDistinctName() {
		return this.defaultDistinctName;
	}

	/**
	 * The default distinct name that is applied to every EJB deployed on this
	 * server
	 */
	@SuppressWarnings("unchecked")
	public T defaultDistinctName(java.lang.String value) {
		Object oldValue = this.defaultDistinctName;
		this.defaultDistinctName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultDistinctName", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the default entity bean instance pool, which will be applicable
	 * to all entity beans, unless overridden at the deployment or bean level
	 */
	@ModelNodeBinding(detypedName = "default-entity-bean-instance-pool")
	public String defaultEntityBeanInstancePool() {
		return this.defaultEntityBeanInstancePool;
	}

	/**
	 * Name of the default entity bean instance pool, which will be applicable
	 * to all entity beans, unless overridden at the deployment or bean level
	 */
	@SuppressWarnings("unchecked")
	public T defaultEntityBeanInstancePool(java.lang.String value) {
		Object oldValue = this.defaultEntityBeanInstancePool;
		this.defaultEntityBeanInstancePool = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultEntityBeanInstancePool",
					oldValue, value);
		return (T) this;
	}

	/**
	 * If set to true entity beans will use optimistic locking by default
	 */
	@ModelNodeBinding(detypedName = "default-entity-bean-optimistic-locking")
	public Boolean defaultEntityBeanOptimisticLocking() {
		return this.defaultEntityBeanOptimisticLocking;
	}

	/**
	 * If set to true entity beans will use optimistic locking by default
	 */
	@SuppressWarnings("unchecked")
	public T defaultEntityBeanOptimisticLocking(java.lang.Boolean value) {
		Object oldValue = this.defaultEntityBeanOptimisticLocking;
		this.defaultEntityBeanOptimisticLocking = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultEntityBeanOptimisticLocking",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the default MDB instance pool, which will be applicable to all
	 * MDBs, unless overridden at the deployment or bean level
	 */
	@ModelNodeBinding(detypedName = "default-mdb-instance-pool")
	public String defaultMdbInstancePool() {
		return this.defaultMdbInstancePool;
	}

	/**
	 * Name of the default MDB instance pool, which will be applicable to all
	 * MDBs, unless overridden at the deployment or bean level
	 */
	@SuppressWarnings("unchecked")
	public T defaultMdbInstancePool(java.lang.String value) {
		Object oldValue = this.defaultMdbInstancePool;
		this.defaultMdbInstancePool = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultMdbInstancePool", oldValue,
					value);
		return (T) this;
	}

	/**
	 * If this is set to true then methods on an EJB with a security domain
	 * specified or with other methods with security metadata will have an
	 * implicit @DenyAll unless other security metadata is present
	 */
	@ModelNodeBinding(detypedName = "default-missing-method-permissions-deny-access")
	public Boolean defaultMissingMethodPermissionsDenyAccess() {
		return this.defaultMissingMethodPermissionsDenyAccess;
	}

	/**
	 * If this is set to true then methods on an EJB with a security domain
	 * specified or with other methods with security metadata will have an
	 * implicit @DenyAll unless other security metadata is present
	 */
	@SuppressWarnings("unchecked")
	public T defaultMissingMethodPermissionsDenyAccess(java.lang.Boolean value) {
		Object oldValue = this.defaultMissingMethodPermissionsDenyAccess;
		this.defaultMissingMethodPermissionsDenyAccess = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange(
					"defaultMissingMethodPermissionsDenyAccess", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Name of the default resource adapter name that will be used by MDBs,
	 * unless overridden at the deployment or bean level
	 */
	@ModelNodeBinding(detypedName = "default-resource-adapter-name")
	public String defaultResourceAdapterName() {
		return this.defaultResourceAdapterName;
	}

	/**
	 * Name of the default resource adapter name that will be used by MDBs,
	 * unless overridden at the deployment or bean level
	 */
	@SuppressWarnings("unchecked")
	public T defaultResourceAdapterName(java.lang.String value) {
		Object oldValue = this.defaultResourceAdapterName;
		this.defaultResourceAdapterName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultResourceAdapterName", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The default security domain that will be used for EJBs if the bean
	 * doesn't explicitly specify one
	 */
	@ModelNodeBinding(detypedName = "default-security-domain")
	public String defaultSecurityDomain() {
		return this.defaultSecurityDomain;
	}

	/**
	 * The default security domain that will be used for EJBs if the bean
	 * doesn't explicitly specify one
	 */
	@SuppressWarnings("unchecked")
	public T defaultSecurityDomain(java.lang.String value) {
		Object oldValue = this.defaultSecurityDomain;
		this.defaultSecurityDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultSecurityDomain", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Name of the default stateful bean cache, which will be applicable to all
	 * stateful EJBs, unless overridden at the deployment or bean level
	 */
	@ModelNodeBinding(detypedName = "default-sfsb-cache")
	public String defaultSfsbCache() {
		return this.defaultSfsbCache;
	}

	/**
	 * Name of the default stateful bean cache, which will be applicable to all
	 * stateful EJBs, unless overridden at the deployment or bean level
	 */
	@SuppressWarnings("unchecked")
	public T defaultSfsbCache(java.lang.String value) {
		Object oldValue = this.defaultSfsbCache;
		this.defaultSfsbCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultSfsbCache", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the default stateful bean cache, which will be applicable to all
	 * stateful EJBs which have passivation disabled. Each deployment or EJB can
	 * optionally override this cache name.
	 */
	@ModelNodeBinding(detypedName = "default-sfsb-passivation-disabled-cache")
	public String defaultSfsbPassivationDisabledCache() {
		return this.defaultSfsbPassivationDisabledCache;
	}

	/**
	 * Name of the default stateful bean cache, which will be applicable to all
	 * stateful EJBs which have passivation disabled. Each deployment or EJB can
	 * optionally override this cache name.
	 */
	@SuppressWarnings("unchecked")
	public T defaultSfsbPassivationDisabledCache(java.lang.String value) {
		Object oldValue = this.defaultSfsbPassivationDisabledCache;
		this.defaultSfsbPassivationDisabledCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultSfsbPassivationDisabledCache",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The default access timeout for singleton beans
	 */
	@ModelNodeBinding(detypedName = "default-singleton-bean-access-timeout")
	public Long defaultSingletonBeanAccessTimeout() {
		return this.defaultSingletonBeanAccessTimeout;
	}

	/**
	 * The default access timeout for singleton beans
	 */
	@SuppressWarnings("unchecked")
	public T defaultSingletonBeanAccessTimeout(java.lang.Long value) {
		Object oldValue = this.defaultSingletonBeanAccessTimeout;
		this.defaultSingletonBeanAccessTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultSingletonBeanAccessTimeout",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the default stateless bean instance pool, which will be
	 * applicable to all stateless EJBs, unless overridden at the deployment or
	 * bean level
	 */
	@ModelNodeBinding(detypedName = "default-slsb-instance-pool")
	public String defaultSlsbInstancePool() {
		return this.defaultSlsbInstancePool;
	}

	/**
	 * Name of the default stateless bean instance pool, which will be
	 * applicable to all stateless EJBs, unless overridden at the deployment or
	 * bean level
	 */
	@SuppressWarnings("unchecked")
	public T defaultSlsbInstancePool(java.lang.String value) {
		Object oldValue = this.defaultSlsbInstancePool;
		this.defaultSlsbInstancePool = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultSlsbInstancePool", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The default access timeout for stateful beans
	 */
	@ModelNodeBinding(detypedName = "default-stateful-bean-access-timeout")
	public Long defaultStatefulBeanAccessTimeout() {
		return this.defaultStatefulBeanAccessTimeout;
	}

	/**
	 * The default access timeout for stateful beans
	 */
	@SuppressWarnings("unchecked")
	public T defaultStatefulBeanAccessTimeout(java.lang.Long value) {
		Object oldValue = this.defaultStatefulBeanAccessTimeout;
		this.defaultStatefulBeanAccessTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultStatefulBeanAccessTimeout",
					oldValue, value);
		return (T) this;
	}

	/**
	 * This deprecated attribute has no effect and will be removed in a future
	 * release; it may never be set to a "false" value
	 */
	@ModelNodeBinding(detypedName = "disable-default-ejb-permissions")
	public Boolean disableDefaultEjbPermissions() {
		return this.disableDefaultEjbPermissions;
	}

	/**
	 * This deprecated attribute has no effect and will be removed in a future
	 * release; it may never be set to a "false" value
	 */
	@SuppressWarnings("unchecked")
	public T disableDefaultEjbPermissions(java.lang.Boolean value) {
		Object oldValue = this.disableDefaultEjbPermissions;
		this.disableDefaultEjbPermissions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("disableDefaultEjbPermissions",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Enabling txn graceful shutdown will make the server wait for active
	 * EJB-related transactions to complete before suspending. For that reason,
	 * if the server is running on a cluster, the suspending cluster node may
	 * receive ejb requests until all active transactions are complete. To avoid
	 * this behavior, omit this tag.
	 */
	@ModelNodeBinding(detypedName = "enable-graceful-txn-shutdown")
	public Boolean enableGracefulTxnShutdown() {
		return this.enableGracefulTxnShutdown;
	}

	/**
	 * Enabling txn graceful shutdown will make the server wait for active
	 * EJB-related transactions to complete before suspending. For that reason,
	 * if the server is running on a cluster, the suspending cluster node may
	 * receive ejb requests until all active transactions are complete. To avoid
	 * this behavior, omit this tag.
	 */
	@SuppressWarnings("unchecked")
	public T enableGracefulTxnShutdown(java.lang.Boolean value) {
		Object oldValue = this.enableGracefulTxnShutdown;
		this.enableGracefulTxnShutdown = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableGracefulTxnShutdown", oldValue,
					value);
		return (T) this;
	}

	/**
	 * If set to true, enable the collection of invocation statistics.
	 * Deprecated in favour of "statistics-enabled"
	 */
	@ModelNodeBinding(detypedName = "enable-statistics")
	public Boolean enableStatistics() {
		return this.enableStatistics;
	}

	/**
	 * If set to true, enable the collection of invocation statistics.
	 * Deprecated in favour of "statistics-enabled"
	 */
	@SuppressWarnings("unchecked")
	public T enableStatistics(java.lang.Boolean value) {
		Object oldValue = this.enableStatistics;
		this.enableStatistics = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableStatistics", oldValue, value);
		return (T) this;
	}

	/**
	 * If set to false, the parameters to invocations on remote interface of an
	 * EJB, will be passed by reference. Else, the parameters will be passed by
	 * value.
	 */
	@ModelNodeBinding(detypedName = "in-vm-remote-interface-invocation-pass-by-value")
	public Boolean inVmRemoteInterfaceInvocationPassByValue() {
		return this.inVmRemoteInterfaceInvocationPassByValue;
	}

	/**
	 * If set to false, the parameters to invocations on remote interface of an
	 * EJB, will be passed by reference. Else, the parameters will be passed by
	 * value.
	 */
	@SuppressWarnings("unchecked")
	public T inVmRemoteInterfaceInvocationPassByValue(java.lang.Boolean value) {
		Object oldValue = this.inVmRemoteInterfaceInvocationPassByValue;
		this.inVmRemoteInterfaceInvocationPassByValue = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange(
					"inVmRemoteInterfaceInvocationPassByValue", oldValue, value);
		return (T) this;
	}

	/**
	 * If this is true then all EJB system (not application) exceptions will be
	 * logged. The EJB spec mandates this behaviour, however it is not
	 * recommended as it will often result in exceptions being logged twice
	 * (once by the EJB and once by the calling code)
	 */
	@ModelNodeBinding(detypedName = "log-system-exceptions")
	public Boolean logSystemExceptions() {
		return this.logSystemExceptions;
	}

	/**
	 * If this is true then all EJB system (not application) exceptions will be
	 * logged. The EJB spec mandates this behaviour, however it is not
	 * recommended as it will often result in exceptions being logged twice
	 * (once by the EJB and once by the calling code)
	 */
	@SuppressWarnings("unchecked")
	public T logSystemExceptions(java.lang.Boolean value) {
		Object oldValue = this.logSystemExceptions;
		this.logSystemExceptions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("logSystemExceptions", oldValue, value);
		return (T) this;
	}

	/**
	 * If set to true, enable the collection of invocation statistics.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * If set to true, enable the collection of invocation statistics.
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(java.lang.Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}
}