package org.wildfly.swarm.config;

import org.wildfly.swarm.config.JGroups;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JGroupsConsumer<T extends JGroups<T>> {

	/**
	 * Configure a pre-constructed instance of JGroups resource
	 * 
	 * @parameter Instance of JGroups to configure
	 * @return nothing
	 */
	void accept(T value);

	default JGroupsConsumer<T> andThen(JGroupsConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}