package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.mail.MailSessionConsumer;
import org.wildfly.swarm.config.mail.MailSessionSupplier;
import org.wildfly.swarm.config.mail.MailSession;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The mail subsystem
 */
@Address("/subsystem=mail")
@ResourceType("subsystem")
@Implicit
public class Mail<T extends Mail<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private MailResources subresources = new MailResources();

	public Mail() {
		super();
		this.key = "mail";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public MailResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all MailSession objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of MailSession objects.
	 */
	@SuppressWarnings("unchecked")
	public T mailSessions(java.util.List<MailSession> value) {
		this.subresources.mailSessions = value;
		return (T) this;
	}

	/**
	 * Add the MailSession object to the list of subresources
	 * 
	 * @param value
	 *            The MailSession to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mailSession(MailSession value) {
		this.subresources.mailSessions.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a MailSession object to the list of subresources
	 * 
	 * @param key
	 *            The key for the MailSession resource
	 * @param config
	 *            The MailSessionConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mailSession(java.lang.String childKey, MailSessionConsumer consumer) {
		MailSession<? extends MailSession> child = new MailSession<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		mailSession(child);
		return (T) this;
	}

	/**
	 * Create and configure a MailSession object to the list of subresources
	 * 
	 * @param key
	 *            The key for the MailSession resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mailSession(java.lang.String childKey) {
		mailSession(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied MailSession object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T mailSession(MailSessionSupplier supplier) {
		mailSession(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Mail
	 */
	public static class MailResources {
		/**
		 * Mail session definition
		 */
		@ResourceDocumentation("Mail session definition")
		@SubresourceInfo("mailSession")
		private List<MailSession> mailSessions = new java.util.ArrayList<>();

		/**
		 * Get the list of MailSession resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<MailSession> mailSessions() {
			return this.mailSessions;
		}

		public MailSession mailSession(java.lang.String key) {
			return this.mailSessions.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}
}