package org.wildfly.swarm.config.batch.jberet;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A job repository that stores job information in a database.
 */
@Address("/subsystem=batch-jberet/jdbc-job-repository=*")
@ResourceType("jdbc-job-repository")
public class JDBCJobRepository<T extends JDBCJobRepository<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The data source name used to connect to the database.")
	private String dataSource;

	public JDBCJobRepository(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The data source name used to connect to the database.
	 */
	@ModelNodeBinding(detypedName = "data-source")
	public String dataSource() {
		return this.dataSource;
	}

	/**
	 * The data source name used to connect to the database.
	 */
	@SuppressWarnings("unchecked")
	public T dataSource(java.lang.String value) {
		Object oldValue = this.dataSource;
		this.dataSource = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dataSource", oldValue, value);
		return (T) this;
	}
}