package org.wildfly.swarm.config.ee;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A context service
 */
@Address("/subsystem=ee/context-service=*")
@ResourceType("context-service")
public class ContextService<T extends ContextService<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The JNDI Name to lookup the context service.")
	private String jndiName;
	@AttributeDocumentation("Flag which indicates if the transaction setup provider should be used")
	private Boolean useTransactionSetupProvider;

	public ContextService(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The JNDI Name to lookup the context service.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The JNDI Name to lookup the context service.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(java.lang.String value) {
		Object oldValue = this.jndiName;
		this.jndiName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jndiName", oldValue, value);
		return (T) this;
	}

	/**
	 * Flag which indicates if the transaction setup provider should be used
	 */
	@ModelNodeBinding(detypedName = "use-transaction-setup-provider")
	public Boolean useTransactionSetupProvider() {
		return this.useTransactionSetupProvider;
	}

	/**
	 * Flag which indicates if the transaction setup provider should be used
	 */
	@SuppressWarnings("unchecked")
	public T useTransactionSetupProvider(java.lang.Boolean value) {
		Object oldValue = this.useTransactionSetupProvider;
		this.useTransactionSetupProvider = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useTransactionSetupProvider",
					oldValue, value);
		return (T) this;
	}
}