package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A role mapper definition for a role mapper that adds a prefix to each
 * provided.
 */
@Address("/subsystem=elytron/add-prefix-role-mapper=*")
@ResourceType("add-prefix-role-mapper")
public class AddPrefixRoleMapper<T extends AddPrefixRoleMapper<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The prefix to add to each role.")
	private String prefix;

	public AddPrefixRoleMapper(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The prefix to add to each role.
	 */
	@ModelNodeBinding(detypedName = "prefix")
	public String prefix() {
		return this.prefix;
	}

	/**
	 * The prefix to add to each role.
	 */
	@SuppressWarnings("unchecked")
	public T prefix(java.lang.String value) {
		Object oldValue = this.prefix;
		this.prefix = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("prefix", oldValue, value);
		return (T) this;
	}
}