package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AggregatePrincipalTransformer;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AggregatePrincipalTransformerConsumer<T extends AggregatePrincipalTransformer<T>> {

	/**
	 * Configure a pre-constructed instance of AggregatePrincipalTransformer
	 * resource
	 * 
	 * @parameter Instance of AggregatePrincipalTransformer to configure
	 * @return nothing
	 */
	void accept(T value);

	default AggregatePrincipalTransformerConsumer<T> andThen(
			AggregatePrincipalTransformerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}