package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A sasl server factory definition where the sasl server factory is an
 * aggregation of other sasl server factories.
 */
@Address("/subsystem=elytron/aggregate-sasl-server-factory=*")
@ResourceType("aggregate-sasl-server-factory")
public class AggregateSASLServerFactory<T extends AggregateSASLServerFactory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The SASL mechanisms available from this factory after all filtering has been applied.")
	private List<String> availableMechanisms;
	@AttributeDocumentation("The referenced sasl server factories to aggregate.")
	private List<String> saslServerFactories;

	public AggregateSASLServerFactory(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@ModelNodeBinding(detypedName = "available-mechanisms")
	public List<String> availableMechanisms() {
		return this.availableMechanisms;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(java.util.List<String> value) {
		Object oldValue = this.availableMechanisms;
		this.availableMechanisms = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("availableMechanisms", oldValue, value);
		return (T) this;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanism(String value) {
		if (this.availableMechanisms == null) {
			this.availableMechanisms = new java.util.ArrayList<>();
		}
		this.availableMechanisms.add(value);
		return (T) this;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(String... args) {
		availableMechanisms(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The referenced sasl server factories to aggregate.
	 */
	@ModelNodeBinding(detypedName = "sasl-server-factories")
	public List<String> saslServerFactories() {
		return this.saslServerFactories;
	}

	/**
	 * The referenced sasl server factories to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T saslServerFactories(java.util.List<String> value) {
		Object oldValue = this.saslServerFactories;
		this.saslServerFactories = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslServerFactories", oldValue, value);
		return (T) this;
	}

	/**
	 * The referenced sasl server factories to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T saslServerFactory(String value) {
		if (this.saslServerFactories == null) {
			this.saslServerFactories = new java.util.ArrayList<>();
		}
		this.saslServerFactories.add(value);
		return (T) this;
	}

	/**
	 * The referenced sasl server factories to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T saslServerFactories(String... args) {
		saslServerFactories(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}