package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AggregateSASLServerFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AggregateSASLServerFactoryConsumer<T extends AggregateSASLServerFactory<T>> {

	/**
	 * Configure a pre-constructed instance of AggregateSASLServerFactory
	 * resource
	 * 
	 * @parameter Instance of AggregateSASLServerFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default AggregateSASLServerFactoryConsumer<T> andThen(
			AggregateSASLServerFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}