package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * An aggregation of two or more security event listener resources.
 */
@Address("/subsystem=elytron/aggregate-security-event-listener=*")
@ResourceType("aggregate-security-event-listener")
public class AggregateSecurityEventListener<T extends AggregateSecurityEventListener<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The referenced security event listener resources to aggregate.")
	private List<String> securityEventListeners;

	public AggregateSecurityEventListener(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The referenced security event listener resources to aggregate.
	 */
	@ModelNodeBinding(detypedName = "security-event-listeners")
	public List<String> securityEventListeners() {
		return this.securityEventListeners;
	}

	/**
	 * The referenced security event listener resources to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T securityEventListeners(java.util.List<String> value) {
		Object oldValue = this.securityEventListeners;
		this.securityEventListeners = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityEventListeners", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The referenced security event listener resources to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T securityEventListener(String value) {
		if (this.securityEventListeners == null) {
			this.securityEventListeners = new java.util.ArrayList<>();
		}
		this.securityEventListeners.add(value);
		return (T) this;
	}

	/**
	 * The referenced security event listener resources to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T securityEventListeners(String... args) {
		securityEventListeners(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}