package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AggregateSecurityEventListener;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AggregateSecurityEventListenerConsumer<T extends AggregateSecurityEventListener<T>> {

	/**
	 * Configure a pre-constructed instance of AggregateSecurityEventListener
	 * resource
	 * 
	 * @parameter Instance of AggregateSecurityEventListener to configure
	 * @return nothing
	 */
	void accept(T value);

	default AggregateSecurityEventListenerConsumer<T> andThen(
			AggregateSecurityEventListenerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}