package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AuthenticationConfiguration;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AuthenticationConfigurationConsumer<T extends AuthenticationConfiguration<T>> {

	/**
	 * Configure a pre-constructed instance of AuthenticationConfiguration
	 * resource
	 * 
	 * @parameter Instance of AuthenticationConfiguration to configure
	 * @return nothing
	 */
	void accept(T value);

	default AuthenticationConfigurationConsumer<T> andThen(
			AuthenticationConfigurationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}