package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * An individual authentication context definition.
 */
@Address("/subsystem=elytron/authentication-context=*")
@ResourceType("authentication-context")
public class AuthenticationContext<T extends AuthenticationContext<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("A previously defined authentication context to extend.")
	private String attributeExtends;
	@AttributeDocumentation("The match-rules for this authentication context.")
	private List<java.util.Map> matchRules;

	public AuthenticationContext(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * A previously defined authentication context to extend.
	 */
	@ModelNodeBinding(detypedName = "extends")
	public String attributeExtends() {
		return this.attributeExtends;
	}

	/**
	 * A previously defined authentication context to extend.
	 */
	@SuppressWarnings("unchecked")
	public T attributeExtends(java.lang.String value) {
		Object oldValue = this.attributeExtends;
		this.attributeExtends = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeExtends", oldValue, value);
		return (T) this;
	}

	/**
	 * The match-rules for this authentication context.
	 */
	@ModelNodeBinding(detypedName = "match-rules")
	public List<Map> matchRules() {
		return this.matchRules;
	}

	/**
	 * The match-rules for this authentication context.
	 */
	@SuppressWarnings("unchecked")
	public T matchRules(java.util.List<java.util.Map> value) {
		Object oldValue = this.matchRules;
		this.matchRules = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("matchRules", oldValue, value);
		return (T) this;
	}

	/**
	 * The match-rules for this authentication context.
	 */
	@SuppressWarnings("unchecked")
	public T matchRule(java.util.Map value) {
		if (this.matchRules == null) {
			this.matchRules = new java.util.ArrayList<>();
		}
		this.matchRules.add(value);
		return (T) this;
	}

	/**
	 * The match-rules for this authentication context.
	 */
	@SuppressWarnings("unchecked")
	public T matchRules(java.util.Map... args) {
		matchRules(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}