package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ConstantPrincipalDecoder;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConstantPrincipalDecoderConsumer<T extends ConstantPrincipalDecoder<T>> {

	/**
	 * Configure a pre-constructed instance of ConstantPrincipalDecoder resource
	 * 
	 * @parameter Instance of ConstantPrincipalDecoder to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConstantPrincipalDecoderConsumer<T> andThen(
			ConstantPrincipalDecoderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}