package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A principal transformer definition for a PrincipalTransformer that always
 * returns the same constant.
 */
@Address("/subsystem=elytron/constant-principal-transformer=*")
@ResourceType("constant-principal-transformer")
public class ConstantPrincipalTransformer<T extends ConstantPrincipalTransformer<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The constant value this PrincipalTransformer will always return.")
	private String constant;

	public ConstantPrincipalTransformer(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The constant value this PrincipalTransformer will always return.
	 */
	@ModelNodeBinding(detypedName = "constant")
	public String constant() {
		return this.constant;
	}

	/**
	 * The constant value this PrincipalTransformer will always return.
	 */
	@SuppressWarnings("unchecked")
	public T constant(java.lang.String value) {
		Object oldValue = this.constant;
		this.constant = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("constant", oldValue, value);
		return (T) this;
	}
}