package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ConstantRealmMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConstantRealmMapperConsumer<T extends ConstantRealmMapper<T>> {

	/**
	 * Configure a pre-constructed instance of ConstantRealmMapper resource
	 * 
	 * @parameter Instance of ConstantRealmMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConstantRealmMapperConsumer<T> andThen(
			ConstantRealmMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}