package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ConstantRoleMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConstantRoleMapperConsumer<T extends ConstantRoleMapper<T>> {

	/**
	 * Configure a pre-constructed instance of ConstantRoleMapper resource
	 * 
	 * @parameter Instance of ConstantRoleMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConstantRoleMapperConsumer<T> andThen(
			ConstantRoleMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}