package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CredentialStore;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CredentialStoreConsumer<T extends CredentialStore<T>> {

	/**
	 * Configure a pre-constructed instance of CredentialStore resource
	 * 
	 * @parameter Instance of CredentialStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default CredentialStoreConsumer<T> andThen(CredentialStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}