package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CustomModifiableRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomModifiableRealmConsumer<T extends CustomModifiableRealm<T>> {

	/**
	 * Configure a pre-constructed instance of CustomModifiableRealm resource
	 * 
	 * @parameter Instance of CustomModifiableRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomModifiableRealmConsumer<T> andThen(
			CustomModifiableRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}