package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CustomPrincipalTransformer;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomPrincipalTransformerConsumer<T extends CustomPrincipalTransformer<T>> {

	/**
	 * Configure a pre-constructed instance of CustomPrincipalTransformer
	 * resource
	 * 
	 * @parameter Instance of CustomPrincipalTransformer to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomPrincipalTransformerConsumer<T> andThen(
			CustomPrincipalTransformerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}