package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CustomRoleDecoder;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomRoleDecoderConsumer<T extends CustomRoleDecoder<T>> {

	/**
	 * Configure a pre-constructed instance of CustomRoleDecoder resource
	 * 
	 * @parameter Instance of CustomRoleDecoder to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomRoleDecoderConsumer<T> andThen(
			CustomRoleDecoderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}