package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.Arrays;

/**
 * The configuration to connect to a directory (LDAP) server.
 */
@Address("/subsystem=elytron/dir-context=*")
@ResourceType("dir-context")
public class DirContext<T extends DirContext<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The authentication context to obtain login credentials to connect to the LDAP server. Can be omitted if authentication-level is \"none\" (anonymous).")
	private String authenticationContext;
	@AttributeDocumentation("The authentication level (security level/authentication mechanism) to use. Corresponds to SECURITY_AUTHENTICATION (\"java.naming.security.authentication\") environment property. Allowed values: \"none\", \"simple\", sasl_mech, where sasl_mech is a space-separated list of SASL mechanism names.")
	private String authenticationLevel;
	@AttributeDocumentation("The timeout for connecting to the LDAP server in milliseconds.")
	private Integer connectionTimeout;
	@AttributeDocumentation("The credential reference to authenticate and connect to the LDAP server. Can be omitted if authentication-level is \"none\" (anonymous).")
	private Map credentialReference;
	@AttributeDocumentation("Indicates if connection pooling is enabled.")
	private Boolean enableConnectionPooling;
	@AttributeDocumentation("Name of module that will be used as class loading base.")
	private String module;
	@AttributeDocumentation("The principal to authenticate and connect to the LDAP server. Can be omitted if authentication-level is \"none\" (anonymous).")
	private String principal;
	@AttributeDocumentation("The additional connection properties for the DirContext.")
	private Map properties;
	@AttributeDocumentation("The read timeout for an LDAP operation in milliseconds.")
	private Integer readTimeout;
	@AttributeDocumentation("If referrals should be followed.")
	private ReferralMode referralMode;
	@AttributeDocumentation("The name of ssl-context used to secure connection to the LDAP server.")
	private String sslContext;
	@AttributeDocumentation("The connection url.")
	private String url;

	public DirContext(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum ReferralMode {
		FOLLOW("FOLLOW"), IGNORE("IGNORE"), THROW("THROW");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		ReferralMode(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The authentication context to obtain login credentials to connect to the
	 * LDAP server. Can be omitted if authentication-level is "none"
	 * (anonymous).
	 */
	@ModelNodeBinding(detypedName = "authentication-context")
	public String authenticationContext() {
		return this.authenticationContext;
	}

	/**
	 * The authentication context to obtain login credentials to connect to the
	 * LDAP server. Can be omitted if authentication-level is "none"
	 * (anonymous).
	 */
	@SuppressWarnings("unchecked")
	public T authenticationContext(java.lang.String value) {
		Object oldValue = this.authenticationContext;
		this.authenticationContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authenticationContext", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The authentication level (security level/authentication mechanism) to
	 * use. Corresponds to SECURITY_AUTHENTICATION
	 * ("java.naming.security.authentication") environment property. Allowed
	 * values: "none", "simple", sasl_mech, where sasl_mech is a space-separated
	 * list of SASL mechanism names.
	 */
	@ModelNodeBinding(detypedName = "authentication-level")
	public String authenticationLevel() {
		return this.authenticationLevel;
	}

	/**
	 * The authentication level (security level/authentication mechanism) to
	 * use. Corresponds to SECURITY_AUTHENTICATION
	 * ("java.naming.security.authentication") environment property. Allowed
	 * values: "none", "simple", sasl_mech, where sasl_mech is a space-separated
	 * list of SASL mechanism names.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationLevel(java.lang.String value) {
		Object oldValue = this.authenticationLevel;
		this.authenticationLevel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authenticationLevel", oldValue, value);
		return (T) this;
	}

	/**
	 * The timeout for connecting to the LDAP server in milliseconds.
	 */
	@ModelNodeBinding(detypedName = "connection-timeout")
	public Integer connectionTimeout() {
		return this.connectionTimeout;
	}

	/**
	 * The timeout for connecting to the LDAP server in milliseconds.
	 */
	@SuppressWarnings("unchecked")
	public T connectionTimeout(java.lang.Integer value) {
		Object oldValue = this.connectionTimeout;
		this.connectionTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The credential reference to authenticate and connect to the LDAP server.
	 * Can be omitted if authentication-level is "none" (anonymous).
	 */
	@ModelNodeBinding(detypedName = "credential-reference")
	public Map credentialReference() {
		return this.credentialReference;
	}

	/**
	 * The credential reference to authenticate and connect to the LDAP server.
	 * Can be omitted if authentication-level is "none" (anonymous).
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.util.Map value) {
		Object oldValue = this.credentialReference;
		this.credentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("credentialReference", oldValue, value);
		return (T) this;
	}

	/**
	 * The credential reference to authenticate and connect to the LDAP server.
	 * Can be omitted if authentication-level is "none" (anonymous).
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.lang.String key, java.lang.Object value) {
		if (this.credentialReference == null) {
			this.credentialReference = new java.util.HashMap<>();
		}
		this.credentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * Indicates if connection pooling is enabled.
	 */
	@ModelNodeBinding(detypedName = "enable-connection-pooling")
	public Boolean enableConnectionPooling() {
		return this.enableConnectionPooling;
	}

	/**
	 * Indicates if connection pooling is enabled.
	 */
	@SuppressWarnings("unchecked")
	public T enableConnectionPooling(java.lang.Boolean value) {
		Object oldValue = this.enableConnectionPooling;
		this.enableConnectionPooling = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableConnectionPooling", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Name of module that will be used as class loading base.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Name of module that will be used as class loading base.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * The principal to authenticate and connect to the LDAP server. Can be
	 * omitted if authentication-level is "none" (anonymous).
	 */
	@ModelNodeBinding(detypedName = "principal")
	public String principal() {
		return this.principal;
	}

	/**
	 * The principal to authenticate and connect to the LDAP server. Can be
	 * omitted if authentication-level is "none" (anonymous).
	 */
	@SuppressWarnings("unchecked")
	public T principal(java.lang.String value) {
		Object oldValue = this.principal;
		this.principal = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("principal", oldValue, value);
		return (T) this;
	}

	/**
	 * The additional connection properties for the DirContext.
	 */
	@ModelNodeBinding(detypedName = "properties")
	public Map properties() {
		return this.properties;
	}

	/**
	 * The additional connection properties for the DirContext.
	 */
	@SuppressWarnings("unchecked")
	public T properties(java.util.Map value) {
		Object oldValue = this.properties;
		this.properties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("properties", oldValue, value);
		return (T) this;
	}

	/**
	 * The additional connection properties for the DirContext.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String key, java.lang.Object value) {
		if (this.properties == null) {
			this.properties = new java.util.HashMap<>();
		}
		this.properties.put(key, value);
		return (T) this;
	}

	/**
	 * The read timeout for an LDAP operation in milliseconds.
	 */
	@ModelNodeBinding(detypedName = "read-timeout")
	public Integer readTimeout() {
		return this.readTimeout;
	}

	/**
	 * The read timeout for an LDAP operation in milliseconds.
	 */
	@SuppressWarnings("unchecked")
	public T readTimeout(java.lang.Integer value) {
		Object oldValue = this.readTimeout;
		this.readTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("readTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * If referrals should be followed.
	 */
	@ModelNodeBinding(detypedName = "referral-mode")
	public ReferralMode referralMode() {
		return this.referralMode;
	}

	/**
	 * If referrals should be followed.
	 */
	@SuppressWarnings("unchecked")
	public T referralMode(ReferralMode value) {
		Object oldValue = this.referralMode;
		this.referralMode = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("referralMode", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of ssl-context used to secure connection to the LDAP server.
	 */
	@ModelNodeBinding(detypedName = "ssl-context")
	public String sslContext() {
		return this.sslContext;
	}

	/**
	 * The name of ssl-context used to secure connection to the LDAP server.
	 */
	@SuppressWarnings("unchecked")
	public T sslContext(java.lang.String value) {
		Object oldValue = this.sslContext;
		this.sslContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sslContext", oldValue, value);
		return (T) this;
	}

	/**
	 * The connection url.
	 */
	@ModelNodeBinding(detypedName = "url")
	public String url() {
		return this.url;
	}

	/**
	 * The connection url.
	 */
	@SuppressWarnings("unchecked")
	public T url(java.lang.String value) {
		Object oldValue = this.url;
		this.url = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("url", oldValue, value);
		return (T) this;
	}
}