package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A simple security realm definition backed by the filesystem.
 */
@Address("/subsystem=elytron/filesystem-realm=*")
@ResourceType("filesystem-realm")
public class FilesystemRealm<T extends FilesystemRealm<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Whether the identity names should be stored encoded (Base32) in file names.")
	private Boolean encoded;
	@AttributeDocumentation("The number of levels of directory hashing to apply.")
	private Integer levels;
	@AttributeDocumentation("The path to the file containing the realm.")
	private String path;
	@AttributeDocumentation("The pre-defined path the path is relative to.")
	private String relativeTo;

	public FilesystemRealm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Whether the identity names should be stored encoded (Base32) in file
	 * names.
	 */
	@ModelNodeBinding(detypedName = "encoded")
	public Boolean encoded() {
		return this.encoded;
	}

	/**
	 * Whether the identity names should be stored encoded (Base32) in file
	 * names.
	 */
	@SuppressWarnings("unchecked")
	public T encoded(java.lang.Boolean value) {
		Object oldValue = this.encoded;
		this.encoded = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("encoded", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of levels of directory hashing to apply.
	 */
	@ModelNodeBinding(detypedName = "levels")
	public Integer levels() {
		return this.levels;
	}

	/**
	 * The number of levels of directory hashing to apply.
	 */
	@SuppressWarnings("unchecked")
	public T levels(java.lang.Integer value) {
		Object oldValue = this.levels;
		this.levels = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("levels", oldValue, value);
		return (T) this;
	}

	/**
	 * The path to the file containing the realm.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * The path to the file containing the realm.
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * The pre-defined path the path is relative to.
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The pre-defined path the path is relative to.
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(java.lang.String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}
}