package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.LdapRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LdapRealmConsumer<T extends LdapRealm<T>> {

	/**
	 * Configure a pre-constructed instance of LdapRealm resource
	 * 
	 * @parameter Instance of LdapRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default LdapRealmConsumer<T> andThen(LdapRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}