package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.LogicalRoleMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LogicalRoleMapperConsumer<T extends LogicalRoleMapper<T>> {

	/**
	 * Configure a pre-constructed instance of LogicalRoleMapper resource
	 * 
	 * @parameter Instance of LogicalRoleMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default LogicalRoleMapperConsumer<T> andThen(
			LogicalRoleMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}